/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

/*
 * Created on 21 juin 2005
 *
 */
package org.eclipse.mddi.modelbus.adapter.test.plugin;


import org.apache.log4j.Logger;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.mddi.modelbus.adapter.infrastructure.LoggerConfigurator;
import org.eclipse.mddi.modelbus.adapter.test.plugin.ui.ConsoleView;
import org.eclipse.mddi.modelbus.adapter.test.registry.BasicRegistry;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

/**
 *  Runs the Test Registry.
 *  See the method run() in this class.
 * 
 * @author Andrey Sadovykh (LIP6)
 *
 */
public class TestRegistryAction implements IWorkbenchWindowActionDelegate {
    
	private IWorkbenchWindow window;
    
    private static Logger logger = Logger.getLogger(TestRegistryAction.class);
	
	
	boolean isStarted = false;
    
 	
	/**
	 * The constructor.
	 */
	public TestRegistryAction() {
        LoggerConfigurator.configure();
	}

	/**
	 * Runs Registry.
	 */
	public void run(IAction action) {
        try {            
    	    if(isStarted ==false) {
                isStarted=true;
                BasicRegistry.start(8082);
                ConsoleView.displayMessage("Registry is running\n");
                logger.info("Registry is running");
                
    	    }else{
                isStarted=false;
                BasicRegistry.stop();
                ConsoleView.displayMessage("Registry is stopped\n Please click Run once again to restart the Registry\n");
                logger.info("Registry is stopped");
            }
                      
        } catch (Exception e) {
            ConsoleView.displayMessage("Registry was not started:");
            ConsoleView.displayMessage(e);
            logger.error("Registry was not started:",e);
            
        }
	}

	/**
	 * Selection in the workbench has been changed. We 
	 * can change the state of the 'real' action here
	 * if we want, but this can only happen after 
	 * the delegate has been created.
	 * @see IWorkbenchWindowActionDelegate#selectionChanged
	 */
	public void selectionChanged(IAction action, ISelection selection) {
	}

	/**
	 * We can use this method to dispose of any system
	 * resources we previously allocated.
	 * @see IWorkbenchWindowActionDelegate#dispose
	 */
	public void dispose() {
	}

	/**
	 * We will cache window object in order to
	 * be able to provide parent shell for the message dialog.
	 * @see IWorkbenchWindowActionDelegate#init
	 */
	public void init(IWorkbenchWindow window) {
		this.window = window;
	}
}
