/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

package org.eclipse.mddi.modelbus.adapter.test.sample;

import java.util.Collection;
import java.util.Properties;
import java.util.Vector;

import org.apache.log4j.Logger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.LoggerConfigurator;
import org.eclipse.mddi.modelbus.adapter.test.framework.ConsumerTest;
import org.eclipse.mddi.modelbus.adapter.test.registry.BasicRegistry;
import org.eclipse.mddi.modelbus.adapter.user.AdapterStub;
import org.eclipse.mddi.modelbus.adapter.user.ModelingServiceError;
import org.eclipse.mddi.modelbus.adapter.user.impl.AdapterStubImpl;

/**
 * Example of using Adapter to consume Modeling Services of other tools.
 * The "createNewClass" service is invoked for adding a new class to a model.
 * The new classes are named "class1", "class2", "class3" ...
 * 
 * @author Prawee Sriplakich, Andrey Sadovykh (LIP6)
 *  
 */
public class ConsumerTestSample {

    AdapterStub adapter = null;
    ConsumerTest test1;
    Collection model = new Vector(); // model to be used as input. initially empty
    int count = 1;
    
    private static Logger logger =Logger.getLogger(ConsumerTestSample.class);
    
    Properties prop;
    
    public ConsumerTestSample(Properties p) {
        prop = p;
        LoggerConfigurator.configure();
    }
    
    
    public void runTest() throws Exception {

        if (adapter == null) {

            adapter = new AdapterStubImpl(prop);

        }

        Object[] inputs = new Object[2];

        inputs[0] = "class" +(count++);
        inputs[1] = model;
        test1 = new ConsumerTest(adapter, "testTool.interface1.createNewClass", inputs);
        test1.consume();
        
        // save the output model
        model = (Collection) test1.getOutputs()[0];

    }
    
    public String getModleString() {
        return test1.getString(model);
    }

    /**
     * Invokes createNewClass service 2 times.
     * Display the result of each invocation in the standard output.
     * 
     * @param args
     */
    public static void main(String args[]) {

        String registry_loc;
        if(args.length>0) {
          registry_loc = args[0];            
        } else {
            registry_loc = BasicRegistry.getUrl();
        } 
        
        logger.info("Registry location is:"+registry_loc);
        
        try {
            Properties p = new Properties();
            p.put(AdapterStub.PROP_REGISTRY_LOCATION, registry_loc);            
            
            ConsumerTestSample testSample = new ConsumerTestSample(p);
            
            for(int i=0; i<=6; i++ ) {
              testSample.runTest();
              logger.info("output=" +testSample.getModleString());
            }
        
            
        } catch(ModelingServiceError e) {
            ModelingServiceError err = (ModelingServiceError) e;
            logger.error("ModelingServiceError: " + err.getName());
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

}