/*
 * $RCSfile: SampleNotificationConsumer.java,v $
 * $Date: 2006/01/26 14:52:19 $
 * $Revision: 1.2 $
 * $Author: andreys $
 */
 
/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */
 
/*
 * SampleNotificationConsumer.java  
 * 
 * @author Prawee Sriplakich, Andrey Sadovykh (LIP6)
 * @version $Revision: 1.2 $ $Date: 2006/01/26 14:52:19 $
 *
 */
package org.eclipse.mddi.modelbus.adapter.test.sample;

import org.apache.log4j.Logger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.LoggerConfigurator;
import org.eclipse.mddi.modelbus.adapter.user.notification.Notification;
import org.eclipse.mddi.modelbus.adapter.user.notification.NotificationConsumer;

/**
 * Sample showing how tools can receive notifications.
 * The tool must provide an object implementing NotificationConsumer interface.
 * and link this object with the Adapter.
 * 
 * @author Prawee Sriplakich, Andrey Sadovykh (LIP6)
 *
 *
 */
public class SampleNotificationConsumer implements NotificationConsumer {

    private static Logger logger = Logger.getLogger(SampleNotificationConsumer.class);
    /* (non-Javadoc)
     * @see org.eclipse.mddi.modelbus.adapter.infrastructure.notification.NotificationConsumer#consume(org.eclipse.mddi.modelbus.adapter.infrastructure.notification.Notification)
     */
    public void consume(Notification notif) {
        LoggerConfigurator.configure();
        logger.info("SampleTool: received a notification. name=" 
                +notif.getName() 
                +" data=" +notif.getInfo());
    }

}
