/**
 * <copyright>
 * </copyright>
 *
 * $Id: EnumerationTypeImpl.java,v 1.1 2006/01/24 15:43:01 xblanc Exp $
 */
package org.eclipse.mddi.modelbus.description.abstract_.impl;

import java.util.Collection;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;

import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;

import org.eclipse.mddi.modelbus.description.abstract_.AbstractPackage;
import org.eclipse.mddi.modelbus.description.abstract_.EnumerationType;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Enumeration Type</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.mddi.modelbus.description.abstract_.impl.EnumerationTypeImpl#getLabels <em>Labels</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class EnumerationTypeImpl extends TypeImpl implements EnumerationType {
    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public static final String copyright = "Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.  All rights reserved.This software is published under the terms of the ModelBus Software License in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. A copy of ModelBus Software License is provided with this distribution in doc/LICENSE.txt file.";

    /**
     * The cached value of the '{@link #getLabels() <em>Labels</em>}' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getLabels()
     * @generated
     * @ordered
     */
    protected EList labels = null;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected EnumerationTypeImpl() {
        super();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected EClass eStaticClass() {
        return AbstractPackage.eINSTANCE.getEnumerationType();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EList getLabels() {
        if (labels == null) {
            labels = new EDataTypeUniqueEList(String.class, this, AbstractPackage.ENUMERATION_TYPE__LABELS);
        }
        return labels;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case AbstractPackage.ENUMERATION_TYPE__NAME:
                return getName();
            case AbstractPackage.ENUMERATION_TYPE__LABELS:
                return getLabels();
        }
        return eDynamicGet(eFeature, resolve);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case AbstractPackage.ENUMERATION_TYPE__NAME:
                setName((String)newValue);
                return;
            case AbstractPackage.ENUMERATION_TYPE__LABELS:
                getLabels().clear();
                getLabels().addAll((Collection)newValue);
                return;
        }
        eDynamicSet(eFeature, newValue);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void eUnset(EStructuralFeature eFeature) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case AbstractPackage.ENUMERATION_TYPE__NAME:
                setName(NAME_EDEFAULT);
                return;
            case AbstractPackage.ENUMERATION_TYPE__LABELS:
                getLabels().clear();
                return;
        }
        eDynamicUnset(eFeature);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case AbstractPackage.ENUMERATION_TYPE__NAME:
                return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
            case AbstractPackage.ENUMERATION_TYPE__LABELS:
                return labels != null && !labels.isEmpty();
        }
        return eDynamicIsSet(eFeature);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String toString() {
        if (eIsProxy()) return super.toString();

        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (labels: ");
        result.append(labels);
        result.append(')');
        return result.toString();
    }

} //EnumerationTypeImpl
