/**
 * <copyright>
 * </copyright>
 *
 * $Id: ToolImpl.java,v 1.1 2006/01/24 15:43:01 xblanc Exp $
 */
package org.eclipse.mddi.modelbus.description.concrete.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.mddi.modelbus.description.abstract_.ModelingServiceInterface;

import org.eclipse.mddi.modelbus.description.concrete.ConcretePackage;
import org.eclipse.mddi.modelbus.description.concrete.Property;
import org.eclipse.mddi.modelbus.description.concrete.Tool;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Tool</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.mddi.modelbus.description.concrete.impl.ToolImpl#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.mddi.modelbus.description.concrete.impl.ToolImpl#getInterface <em>Interface</em>}</li>
 *   <li>{@link org.eclipse.mddi.modelbus.description.concrete.impl.ToolImpl#getPlatform <em>Platform</em>}</li>
 *   <li>{@link org.eclipse.mddi.modelbus.description.concrete.impl.ToolImpl#getProperty <em>Property</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class ToolImpl extends EObjectImpl implements Tool {
    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public static final String copyright = "Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.  All rights reserved.This software is published under the terms of the ModelBus Software License in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. A copy of ModelBus Software License is provided with this distribution in doc/LICENSE.txt file.";

    /**
     * The default value of the '{@link #getName() <em>Name</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getName()
     * @generated
     * @ordered
     */
    protected static final String NAME_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getName()
     * @generated
     * @ordered
     */
    protected String name = NAME_EDEFAULT;

    /**
     * The cached value of the '{@link #getInterface() <em>Interface</em>}' reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getInterface()
     * @generated
     * @ordered
     */
    protected ModelingServiceInterface interface_ = null;

    /**
     * The default value of the '{@link #getPlatform() <em>Platform</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getPlatform()
     * @generated
     * @ordered
     */
    protected static final String PLATFORM_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getPlatform() <em>Platform</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getPlatform()
     * @generated
     * @ordered
     */
    protected String platform = PLATFORM_EDEFAULT;

    /**
     * The cached value of the '{@link #getProperty() <em>Property</em>}' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getProperty()
     * @generated
     * @ordered
     */
    protected EList property = null;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ToolImpl() {
        super();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected EClass eStaticClass() {
        return ConcretePackage.eINSTANCE.getTool();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getName() {
        return name;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setName(String newName) {
        String oldName = name;
        name = newName;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, ConcretePackage.TOOL__NAME, oldName, name));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public ModelingServiceInterface getInterface() {
        if (interface_ != null && interface_.eIsProxy()) {
            ModelingServiceInterface oldInterface = interface_;
            interface_ = (ModelingServiceInterface)eResolveProxy((InternalEObject)interface_);
            if (interface_ != oldInterface) {
                if (eNotificationRequired())
                    eNotify(new ENotificationImpl(this, Notification.RESOLVE, ConcretePackage.TOOL__INTERFACE, oldInterface, interface_));
            }
        }
        return interface_;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public ModelingServiceInterface basicGetInterface() {
        return interface_;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setInterface(ModelingServiceInterface newInterface) {
        ModelingServiceInterface oldInterface = interface_;
        interface_ = newInterface;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, ConcretePackage.TOOL__INTERFACE, oldInterface, interface_));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getPlatform() {
        return platform;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setPlatform(String newPlatform) {
        String oldPlatform = platform;
        platform = newPlatform;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, ConcretePackage.TOOL__PLATFORM, oldPlatform, platform));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EList getProperty() {
        if (property == null) {
            property = new EObjectContainmentEList(Property.class, this, ConcretePackage.TOOL__PROPERTY);
        }
        return property;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
                case ConcretePackage.TOOL__PROPERTY:
                    return ((InternalEList)getProperty()).basicRemove(otherEnd, msgs);
                default:
                    return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
            }
        }
        return eBasicSetContainer(null, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case ConcretePackage.TOOL__NAME:
                return getName();
            case ConcretePackage.TOOL__INTERFACE:
                if (resolve) return getInterface();
                return basicGetInterface();
            case ConcretePackage.TOOL__PLATFORM:
                return getPlatform();
            case ConcretePackage.TOOL__PROPERTY:
                return getProperty();
        }
        return eDynamicGet(eFeature, resolve);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case ConcretePackage.TOOL__NAME:
                setName((String)newValue);
                return;
            case ConcretePackage.TOOL__INTERFACE:
                setInterface((ModelingServiceInterface)newValue);
                return;
            case ConcretePackage.TOOL__PLATFORM:
                setPlatform((String)newValue);
                return;
            case ConcretePackage.TOOL__PROPERTY:
                getProperty().clear();
                getProperty().addAll((Collection)newValue);
                return;
        }
        eDynamicSet(eFeature, newValue);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void eUnset(EStructuralFeature eFeature) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case ConcretePackage.TOOL__NAME:
                setName(NAME_EDEFAULT);
                return;
            case ConcretePackage.TOOL__INTERFACE:
                setInterface((ModelingServiceInterface)null);
                return;
            case ConcretePackage.TOOL__PLATFORM:
                setPlatform(PLATFORM_EDEFAULT);
                return;
            case ConcretePackage.TOOL__PROPERTY:
                getProperty().clear();
                return;
        }
        eDynamicUnset(eFeature);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case ConcretePackage.TOOL__NAME:
                return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
            case ConcretePackage.TOOL__INTERFACE:
                return interface_ != null;
            case ConcretePackage.TOOL__PLATFORM:
                return PLATFORM_EDEFAULT == null ? platform != null : !PLATFORM_EDEFAULT.equals(platform);
            case ConcretePackage.TOOL__PROPERTY:
                return property != null && !property.isEmpty();
        }
        return eDynamicIsSet(eFeature);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String toString() {
        if (eIsProxy()) return super.toString();

        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (name: ");
        result.append(name);
        result.append(", platform: ");
        result.append(platform);
        result.append(')');
        return result.toString();
    }

} //ToolImpl
