/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */


/*
 * Created on 17 juin 2005
 *
 */
package org.eclipse.mddi.modelbus.adapter.test.framework;

import java.io.IOException;
import java.util.Collection;

import org.apache.log4j.Logger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.LoggerConfigurator;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.emf_xmi.Emf2XmiConversion;
import org.eclipse.mddi.modelbus.adapter.user.AdapterStub;
import org.eclipse.mddi.modelbus.adapter.user.consumer.GenericConsumer;


/**
 * This is the base interface for all tests (ConsumerTest and ProviderTest).
 * 
 * @author Prawee Sriplakich, Andrey Sadovykh (LIP6)
 */
public class ConsumerTest extends AdapterTest {
    
    Object[] inputs;
    Object[] outputs;
    
    String serviceName;
    
    private static Logger logger=Logger.getLogger(ConsumerTest.class);
    
    
    
    public ConsumerTest(AdapterStub _adapter, String _serviceName, Object[] _inputs) {
        setAdapter(_adapter);
        setServiceName(_serviceName);
        setInputs(_inputs);
        
        LoggerConfigurator.configure();
    }
    
    public Object[] getInputs() {
      return inputs;
    }
    
    public void setInputs(Object[] _inputs) {
          inputs = _inputs;
    } 
   
    public void consume() throws Exception {
        GenericConsumer consumer = getAdapter().getGenericConsumer();
        outputs = consumer.consume(serviceName, inputs);
    }


    public Object[] getOutputs() {
        return outputs;
    }
    
    public void printOutputs() {
        logger.info(getOutputsString());
    }
    
    public String getOutputsString() {
       String s = "";
       for(int i=0; i<1; i++) {
           s = s + "output" +i +" "+getString(outputs[i]) +"\n";
       }    
       return s;
    }
    
    public String getString(Object value) {
      if(value instanceof Collection) {
        // it is a model
        Collection c = (Collection) value;
        try {
            String result = Emf2XmiConversion.convertToString(c);
            return result;
        } catch (IOException e) {
            return "ERROR";
        }
        
      } else if(value instanceof Object[]) {
          Object[] array = (Object[]) value; 
          String result = "{";
          for(int i=0; i<array.length; i++) { 
             result = result + getString(array[i]); 
      	  }
          return result + " }"; 
      } else if(value==null) {
        return "null";    
      } else return value.toString();
    }
    

    public String getServiceName() {
        return serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }
}
