/*
 * $RCSfile: EndPointManager.java,v $
 * $Date: 2006/01/26 14:48:59 $
 * $Revision: 1.1.2.3 $
 * $Author: andreys $
 */
 
/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */
 
/*
 * EndPointManager.java Add description 
 * 
 * @author Prawee Sriplakich, Andrey Sadovykh (LIP6)
 * @version $Revision: 1.1.2.3 $ $Date: 2006/01/26 14:48:59 $
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.transport.server.ws;

import javax.xml.soap.SOAPEnvelope;

public interface EndPointManager {
   
    
    public EndPoint getEndPoint(String relativePath);
    
    /**
     * 
     * Tell the endpoint that any relative parts that begin with the "incompleteRelativePath"
     * will be dispatch to the endPoint
     * 
     * @param incompleteRelativePath A path the follows CONTEXT. 
     * For example, "modelbus/modeling_services/" 
     * must begin without "/"
     * 
     * @param endPoint
     * 
     *
     */
    public void putEndPoint(String incompleteRelativePath, EndPoint endPoint);
    
    /**
     * 
     * execute an action associated with the relative path
     * 
     * @param relativePath A path the follows CONTEXT. It must begin without "/"
     * @param req
     * @param resp
     * 
     *
     */
    public void execute(String relativePath, SOAPEnvelope req, SOAPEnvelope resp);

}
