/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

/*
 * Created on 22 juil. 2005
 *
 */
package org.eclipse.mddi.modelbus.adapter.user;

/**
 * This class represents an error that is produced by the provider tools during service execution.
 * This error must conform to the Error metaclass instance defined in the tool description.
 * Please refer to the tool description metamodel.
 * 
 * @author Prawee Sriplakich (LIP6)
 *
 *
 */
public class ModelingServiceError extends Exception {
    
    /**
     * 
     */
    private static final long serialVersionUID = -5134134489369713196L;

    public ModelingServiceError(String _name, Object _info) {
        name = _name;
        info = _info;
    }
    
    
    /**
     * The name of the error.
     * @see org.eclipse.mddi.modelbus.description.abstract_.Error
     */
    String name;
    
    /**
     * @return Returns the name.
     */
    public String getName() {
        return name;
    }
    /**
     * @param name The name to set.
     */
    public void setName(String name) {
        this.name = name;
    }
    
    /**
     * The information contained by the error.
     * This information can be either primitive data or model.
     * Its type must correspond to the error type defined in the tool description.
     * 
     * @see org.eclipse.mddi.modelbus.description.abstract_.Error
     */    
    Object info;
    
    
    
    
    /**
     * @return Returns the info.
     */
    public Object getInfo() {
        return info;
    }
    /**
     * @param info The info to set.
     */
    public void setInfo(Object info) {
        this.info = info;
    }
    
    /* (non-Javadoc)
     * @see java.lang.Throwable#getMessage()
     */
    public String getMessage() {
        return name;
    }
}
