/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.serialize;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class XmiUtil {
    private static DocumentBuilder docBuilder = null;
    public static Transformer xmlWriter;
    public static final String XMI_NS = "http://www.omg.org/XMI";

    static {
        try {
            docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            xmlWriter = TransformerFactory.newInstance().newTransformer();
            xmlWriter.setOutputProperty("indent", "yes");
            xmlWriter.setOutputProperty("method", "xml");
            xmlWriter.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        }
        catch (Exception e) {
            throw new RuntimeException("XML Parser cannot be initialized", e);
        }
    }

    public static Document parseXml(InputStream in) throws SAXException, IOException {
        DocumentBuilder documentBuilder = docBuilder;
        synchronized (documentBuilder) {
            return docBuilder.parse(in);
        }
    }

    public static Document createDocument() {
        Document doc = null;
        DocumentBuilder documentBuilder = docBuilder;
        synchronized (documentBuilder) {
            doc = docBuilder.newDocument();
        }
        return doc;
    }

    public static void writeToFile(String file, String text) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        out.write(text.getBytes());
        out.close();
    }

    public static String loadFromFile(String file) throws IOException {
        int data;
        FileInputStream in = new FileInputStream(file);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((data = in.read()) != -1) {
            out.write(data);
        }
        in.close();
        byte[] b = out.toByteArray();
        out.close();
        return new String(b);
    }

    public static String xmlElemToString(Element elem) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            XmiUtil.write(elem, out);
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
        return out.toString();
    }

    public static void write(Element elem, OutputStream out) throws IOException {
        DOMSource domSource = new DOMSource(elem);
        try {
            xmlWriter.transform(domSource, new StreamResult(out));
        }
        catch (TransformerException e) {
            throw new IOException(e.toString());
        }
    }
}

