/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.transport.server.ws;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.AdapterContainerImpl;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.server.AbstractServer;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.server.ws.EndPointManagerImpl;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.server.ws.axis.SimpleModelBusServer;
import org.eclipse.mddi.modelbus.adapter.user.AdapterStub;

public class ServerManager {
    public static final String DEFAULT_CONTEXT = "modelbus";
    public static int DEFAULT_MB_PORT = 8081;
    static ServerManager instance = new ServerManager();
    private static Logger logger;
    Set servers = new HashSet();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.mddi.modelbus.adapter.infrastructure.transport.server.ws.ServerManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public static ServerManager getInstance() {
        return instance;
    }

    ServerManager() {
    }

    public void putServer(AbstractServer s) {
        if (this.servers.contains(s)) {
            return;
        }
        this.servers.add(s);
        s.setEndPointManager(EndPointManagerImpl.getInstance());
    }

    public AbstractServer getServer(int port) throws Exception {
        Iterator it = this.servers.iterator();
        while (it.hasNext()) {
            AbstractServer test = (AbstractServer)it.next();
            if (test.getPort() != port) continue;
            return test;
        }
        SimpleModelBusServer s = null;
        s = new SimpleModelBusServer(port);
        this.putServer(s);
        return s;
    }

    public static String getHost() {
        try {
            return InetAddress.getLocalHost().getHostAddress().toString();
        }
        catch (UnknownHostException unknownHostException) {
            logger.error((Object)"The host is not connected to internet");
            return "localhost";
        }
    }

    public static int getModelBusPort(AdapterStub adapter) {
        String portString = adapter.getProperties().getProperty("modelbus_port");
        if (portString != null) {
            try {
                int port = Integer.parseInt(portString);
                return port;
            }
            catch (NumberFormatException numberFormatException) {
                AdapterContainerImpl.logger.error((Object)("Adapter. bad PROP_MODELBUS_PORT (" + portString + "). used default (" + DEFAULT_MB_PORT + ")"));
            }
        }
        return DEFAULT_MB_PORT;
    }
}

