/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.user.impl;

import java.io.IOException;
import java.util.Collection;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.AdapterContainerImpl;
import org.eclipse.mddi.modelbus.adapter.infrastructure.DeploymentException;
import org.eclipse.mddi.modelbus.adapter.infrastructure.LoggerConfigurator;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.DescriptionUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.ModelUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.notification.NotifServiceClient;
import org.eclipse.mddi.modelbus.adapter.infrastructure.notification.NotifServiceManager;
import org.eclipse.mddi.modelbus.adapter.infrastructure.notification.NotifServiceNotAvailableException;
import org.eclipse.mddi.modelbus.adapter.infrastructure.registry.DefaultToolSelector;
import org.eclipse.mddi.modelbus.adapter.infrastructure.registry.RegistryManager;
import org.eclipse.mddi.modelbus.adapter.infrastructure.registry.RegistryNotAvailableException;
import org.eclipse.mddi.modelbus.adapter.infrastructure.registry.ToolSelectionStrategy;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.Serializer;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.emf_xmi.Xmi2EmfConversion;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.TransportManager;
import org.eclipse.mddi.modelbus.adapter.user.AdapterStub;
import org.eclipse.mddi.modelbus.adapter.user.ToolStub;
import org.eclipse.mddi.modelbus.adapter.user.consumer.GenericConsumer;
import org.eclipse.mddi.modelbus.adapter.user.consumer.NoToolAvailableException;
import org.eclipse.mddi.modelbus.adapter.user.consumer.SpecificConsumer;
import org.eclipse.mddi.modelbus.adapter.user.consumer.SpecificInterfaceManager;
import org.eclipse.mddi.modelbus.adapter.user.consumer.impl.GenericConsumerImpl;
import org.eclipse.mddi.modelbus.adapter.user.impl.ToolStubImpl;
import org.eclipse.mddi.modelbus.adapter.user.notification.NotificationPublisher;
import org.eclipse.mddi.modelbus.description.concrete.Tool;

public class AdapterStubImpl
implements AdapterStub {
    Properties properties = null;
    Tool toolDescription = null;
    private GenericConsumerImpl si = new GenericConsumerImpl(this);
    ToolStub toolStub = new ToolStubImpl();
    ToolSelectionStrategy toolSelector = new DefaultToolSelector();
    TransportManager transportManager;
    private static Logger logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.mddi.modelbus.adapter.user.impl.AdapterStubImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public AdapterStubImpl(Properties initProperties) throws DeploymentException {
        String ns_loc;
        LoggerConfigurator.configure();
        this.properties = initProperties;
        String registry_loc = this.properties.getProperty("registry_location");
        this.transportManager = new TransportManager(this);
        DeploymentException ex = new DeploymentException();
        if (registry_loc != null) {
            try {
                RegistryManager.getInstance().getRegistryClient(registry_loc);
            }
            catch (RegistryNotAvailableException e) {
                ex.addProblem("RegistryNotAvailable", e);
            }
        }
        if ((ns_loc = this.properties.getProperty("notification_service_location")) != null) {
            try {
                NotifServiceManager.getInstance().getNotificationServiceClient(ns_loc);
            }
            catch (NotifServiceNotAvailableException e) {
                ex.addProblem("NotifServiceNotAvaiable", e);
            }
        }
        try {
            this.loadDescription();
        }
        catch (IOException e) {
            ex.addProblem("Bad tool description file", e);
        }
        if (ex.hasProblems()) {
            throw ex;
        }
    }

    private void loadDescription() throws IOException {
        String toolDescFile = this.properties.getProperty("tool_desc_file");
        if (toolDescFile == null) {
            return;
        }
        Collection emfobjs = Xmi2EmfConversion.convertFromFile(toolDescFile, false);
        Collection col = ModelUtil.findElementByType(emfobjs, "Tool");
        if (col.isEmpty()) {
            throw new IOException("No tool description found in " + toolDescFile);
        }
        if (col.size() > 1) {
            logger.warn((Object)("Warning. Several Tool Description found in " + toolDescFile));
        }
        this.toolDescription = (Tool)col.iterator().next();
        DescriptionUtil.importAllMetamodels(this.toolDescription);
    }

    public GenericConsumer getGenericServiceInvocation() {
        return this.getGenericConsumer();
    }

    public GenericConsumer getGenericConsumer() {
        return this.si;
    }

    public SpecificConsumer getSpecificServiceInvocation(String modelingServiceInterfaceName) throws NoToolAvailableException {
        SpecificConsumer i = SpecificInterfaceManager.getInstance().getSpecificInterface(modelingServiceInterfaceName);
        if (i != null) {
            return i;
        }
        throw new NoToolAvailableException("for ModelingServiceInterface " + modelingServiceInterfaceName);
    }

    public NotificationPublisher getNotificationPublisher() throws NotifServiceNotAvailableException {
        String notif_loc = this.properties.getProperty("notification_service_location");
        if (notif_loc == null) {
            throw new NotifServiceNotAvailableException("no location specified", null);
        }
        NotifServiceClient pub = NotifServiceManager.getInstance().getNotificationServiceClient(notif_loc);
        return pub;
    }

    public ToolStub getToolStub() {
        return this.toolStub;
    }

    public Tool getToolDescription() {
        return this.toolDescription;
    }

    public void setToolDescription(Tool toolDescription) {
        this.toolDescription = toolDescription;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public ToolSelectionStrategy getToolSelector() {
        return this.toolSelector;
    }

    public void setToolSelector(ToolSelectionStrategy toolSelector) {
        this.toolSelector = toolSelector;
    }

    public TransportManager getTransportManager() {
        return this.transportManager;
    }

    public void deploy() throws DeploymentException {
        AdapterContainerImpl.getInstance().deployAdapter(this);
    }

    public void undeploy() throws DeploymentException {
        AdapterContainerImpl.getInstance().undeployAdapter(this);
    }

    public void setSerializer(Serializer serializer) {
        this.getTransportManager().setSerializer(serializer);
    }
}

