/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.test.unit;

import java.io.IOException;
import java.util.Collection;
import junit.framework.Assert;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.apache.log4j.Logger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.LoggerConfigurator;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.emf_xmi.Emf2XmiConversion;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.emf_xmi.Xmi2EmfConversion;
import org.eclipse.mddi.modelbus.adapter.test.unit.Util;

public class ModelConversionTest
extends TestCase {
    private static Logger logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.mddi.modelbus.adapter.test.unit.ModelConversionTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public static void main(String[] args) {
        LoggerConfigurator.configure();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.mddi.modelbus.adapter.test.unit.ModelConversionTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public void testConvert_ecoreModel() throws IOException {
        Collection model1 = Util.createEcoreModel();
        String s = Emf2XmiConversion.convertToString((Collection)model1);
        logger.info((Object)("testConvert_ecoreModel: \n" + s + "\n\n"));
        Collection model2 = Xmi2EmfConversion.convertFromString((String)s, (boolean)true);
        Assert.assertTrue((boolean)Util.compareModels(model1, model2));
    }

    public void testConvert_umlModel() throws IOException {
        Collection model1 = Util.createUml2Model();
        String s = Emf2XmiConversion.convertToString((Collection)model1);
        logger.info((Object)("testConvert_umlModel: \n" + s + "\n\n"));
        Collection model2 = Xmi2EmfConversion.convertFromString((String)s, (boolean)true);
        Assert.assertTrue((boolean)Util.compareModels(model1, model2));
    }
}

