/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.notification;

import java.net.URL;
import javax.xml.soap.SOAPBody;
import org.activemq.ws.xmlbeans.notification.base.NotificationMessageHolderType;
import org.activemq.ws.xmlbeans.notification.base.NotifyDocument;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.Text;
import org.apache.axis.types.URI;
import org.eclipse.mddi.modelbus.adapter.infrastructure.notification.NotifServiceNotAvailableException;
import org.eclipse.mddi.modelbus.adapter.infrastructure.notification.SerializedNotification;
import org.oasis_open.docs.wsn._2004._06.wsn_WS_BaseNotification_1_2_draft_01_xsd.Notify;
import org.oasis_open.docs.wsn._2004._06.wsn_WS_BaseNotification_1_2_draft_01_xsd.Subscribe;
import org.oasis_open.docs.wsn._2004._06.wsn_WS_BaseNotification_1_2_draft_01_xsd.SubscribeResponse;
import org.oasis_open.docs.wsn._2004._06.wsn_WS_BaseNotification_1_2_draft_01_xsd.TopicExpressionType;
import org.oasis_open.docs.wsn._2004._06.wsn_WS_BrokeredNotification_1_2_draft_01_wsdl.NotificationBroker;
import org.oasis_open.docs.wsn._2004._06.wsn_WS_BrokeredNotification_1_2_draft_01_wsdl.NotificationBrokerServiceLocator;
import org.w3c.dom.CharacterData;
import org.xmlsoap.schemas.ws._2003._03.addressing.AttributedURI;
import org.xmlsoap.schemas.ws._2003._03.addressing.EndpointReferenceType;

public class NotificationServiceUtil {
    private static void subscribeTopic(String notificationBrokerEndpoint, String notificationConsumerEndpoint, String topic) throws NotifServiceNotAvailableException {
        try {
            NotificationBroker broker = new NotificationBrokerServiceLocator().getWsbnwNotificationBroker(new URL(notificationBrokerEndpoint));
            EndpointReferenceType endpoint = new EndpointReferenceType();
            endpoint.setAddress(new AttributedURI(notificationConsumerEndpoint));
            Subscribe subscribeData = new Subscribe();
            subscribeData.setConsumerReference(endpoint);
            MessageElement[] elements = new MessageElement[]{new MessageElement((CharacterData)new Text(topic))};
            TopicExpressionType topicExpressionType = new TopicExpressionType(elements, new URI("http://www.ibm.com/xmlns/stdwip/web-services/WSTopics/TopicExpression/simple"));
            subscribeData.setTopicExpression(topicExpressionType);
            SubscribeResponse r = broker.subscribe(subscribeData);
        }
        catch (Exception e) {
            throw new NotifServiceNotAvailableException(e.toString(), e);
        }
    }

    public static void subscribe(String notificationBrokerEndpoint, String notificationConsumerEndpoint, String[] topics) throws NotifServiceNotAvailableException {
        int i = 0;
        while (i < topics.length) {
            NotificationServiceUtil.subscribeTopic(notificationBrokerEndpoint, notificationConsumerEndpoint, topics[i]);
            ++i;
        }
    }

    public static void unsubscribe() {
    }

    public static void publish(String notificationBrokerEndpoint, String topicExpression, String message) {
        try {
            MessageElement element = new MessageElement((CharacterData)new Text(topicExpression));
            TopicExpressionType topicExpressionType = new TopicExpressionType(new MessageElement[]{element}, new URI("http://www.ibm.com/xmlns/stdwip/web-services/WSTopics/TopicExpression/simple"));
            org.oasis_open.docs.wsn._2004._06.wsn_WS_BaseNotification_1_2_draft_01_xsd.NotificationMessageHolderType notificationMessageHolderType = new org.oasis_open.docs.wsn._2004._06.wsn_WS_BaseNotification_1_2_draft_01_xsd.NotificationMessageHolderType(topicExpressionType, null, message);
            Notify notify = new Notify(new org.oasis_open.docs.wsn._2004._06.wsn_WS_BaseNotification_1_2_draft_01_xsd.NotificationMessageHolderType[]{notificationMessageHolderType});
            NotificationBroker broker = new NotificationBrokerServiceLocator().getWsbnwNotificationBroker(new URL(notificationBrokerEndpoint));
            broker.notify(notify);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static SerializedNotification[] extractNotifications(SOAPBody body) {
        String bodyString = body.getChildNodes().item(0).toString();
        NotifyDocument notifyDocument = null;
        try {
            notifyDocument = NotifyDocument.Factory.parse((String)bodyString);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        NotificationMessageHolderType[] notificationMessages = notifyDocument.getNotify().getNotificationMessageArray();
        SerializedNotification[] results = new SerializedNotification[notificationMessages.length];
        int i = 0;
        while (i < notificationMessages.length) {
            results[i] = new SerializedNotification();
            results[i].message = notificationMessages[i].getMessage().getDomNode().getFirstChild().getNodeValue();
            results[i].topic = notificationMessages[i].getTopic().getDomNode().getFirstChild().getNodeValue();
            ++i;
        }
        return results;
    }
}

