/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.modelbus_xmi;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.WeakHashMap;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.modelbus_xmi.IdGenerator;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.modelbus_xmi.SimpleIdGenerator;

public class IdTable {
    static Logger logger;
    IdGenerator idGenerator = new SimpleIdGenerator();
    private Map obj_id = new WeakHashMap();
    private Map id_ref = new WeakHashMap();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.modelbus_xmi.IdTable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public String getId(EObject o) {
        return (String)this.obj_id.get(o);
    }

    public String getOrCreateId(EObject o) {
        if (!this.obj_id.containsKey(o)) {
            String id = this.idGenerator.generateId(o, this.id_ref.keySet());
            this.assignId(id, o);
            return id;
        }
        return (String)this.obj_id.get(o);
    }

    public void assignId(String id, EObject o) {
        this.obj_id.put(o, id);
        this.id_ref.put(id, new WeakReference<EObject>(o));
    }

    public String changeId(String oldID, Collection idSet) {
        EObject o = this.getModelElement(oldID);
        if (o == null) {
            return null;
        }
        String newID = this.idGenerator.generateId(o, this.id_ref.keySet(), idSet);
        this.assignId(newID, o);
        return newID;
    }

    public void addAll(Collection modelElements) {
        Iterator it = modelElements.iterator();
        while (it.hasNext()) {
            this.getOrCreateId((EObject)it.next());
        }
    }

    public void clear() {
        this.id_ref.clear();
        this.obj_id.clear();
    }

    public EObject getModelElement(String id) {
        Reference r = (Reference)this.id_ref.get(id);
        if (r == null) {
            return null;
        }
        if (r.get() == null) {
            logger.error((Object)("object " + id + " has been garbage collected"));
            return null;
        }
        return (EObject)r.get();
    }

    public List getFragmentFromIds(Collection ids) {
        Vector<EObject> result = new Vector<EObject>();
        Iterator it = ids.iterator();
        while (it.hasNext()) {
            String id = (String)it.next();
            EObject e = this.getModelElement(id);
            if (e == null) continue;
            result.add(e);
        }
        return result;
    }

    public Collection getIdSet() {
        return this.id_ref.keySet();
    }

    public List getIdsFromFragment(Collection fragment) {
        Vector<String> result = new Vector<String>();
        Iterator it = fragment.iterator();
        while (it.hasNext()) {
            EObject e = (EObject)it.next();
            String id = (String)this.obj_id.get(e);
            if (id == null) continue;
            result.add(id);
        }
        return result;
    }

    public Collection getModel() {
        return this.obj_id.keySet();
    }
}

