/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.modelbus_xmi;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.xmi.XMIException;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.ModelWrapper;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.wrapper.emf.EmfModelWrapper;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.modelbus_xmi.IdTable;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.modelbus_xmi.MBXmiResource;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.modelbus_xmi.ModelDeserializer;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.modelbus_xmi.ModelSerializer;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.modelbus_xmi.UpdaterByCopy;
import org.xml.sax.SAXException;

public class ModelManager {
    String format = "EMF";
    Collection model = new HashSet();
    IdTable idTable = new IdTable();

    static {
        ModelWrapper.addRegistry("EMF", new EmfModelWrapper());
    }

    public ModelManager() {
        this.setFormat("EMF");
    }

    public void clear() {
        this.model.clear();
        this.idTable.clear();
    }

    public Collection loadXMI(String serializedModel) throws SAXException, IOException, XMIException {
        MBXmiResource r = new MBXmiResource(URI.createURI((String)"uri1"), this.idTable);
        ModelDeserializer deser = new ModelDeserializer(r);
        deser.setFormat(this.format);
        deser.deserialize(serializedModel);
        this.model.addAll(deser.getCreatedModelElements());
        return deser.getCreatedModelElements();
    }

    public Collection getManagedModel() {
        return this.model;
    }

    public void printIds() {
        System.out.println(this.idTable.getIdSet());
    }

    public void mergeWithXMI(Collection originalFragment, String xmi) throws SAXException, IOException, XMIException {
        MBXmiResource r = new MBXmiResource(URI.createURI((String)"uri1"));
        ModelDeserializer deser = new ModelDeserializer(r);
        deser.setFormat(this.format);
        deser.deserialize(xmi);
        UpdaterByCopy updater = new UpdaterByCopy(this.idTable, originalFragment, r.getIdTable(), deser.getCreatedModelElements());
        updater.update();
        List removedElements = this.idTable.getFragmentFromIds(updater.getRemovedElementIds());
        this.removeElements(removedElements);
        originalFragment.clear();
        originalFragment.addAll(updater.getResultFragment());
    }

    public void removeElements(Collection elements) {
        this.model.removeAll(elements);
        Hashtable m = new Hashtable();
        Iterator it = elements.iterator();
        while (it.hasNext()) {
        }
    }

    public String exportToXMI() {
        return this.exportFragmentToXMI(this.model);
    }

    public String exportFragmentToXMI(Collection fragment) {
        ModelSerializer ser = new ModelSerializer(this.idTable);
        return ser.serializeFragment(fragment);
    }

    public IdTable getIdTable() {
        return this.idTable;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }
}

