/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.transport;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.AdapterContainerImpl;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.DescriptionUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.Serializer;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ProviderProxy;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.SessionManager;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.SessionProviderProxy;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.client.AbstractInvocationSender;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.client.local.LocalInvocationSender;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.client.local.LocalSessionInvocationSender;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.client.ws.CopyRestoreFragmentWsInvocationSender;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.client.ws.DefaultSessionWsInvocationSender;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.client.ws.DefaultWsInvocationSender;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.server.ws.CopyRestoreFragmentWsInvocationReceiver;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.server.ws.DefaultSessionWsInvocationReceiver;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.server.ws.DefaultWsInvocationReceiver;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.server.ws.WsInvocationReceiver;
import org.eclipse.mddi.modelbus.adapter.user.AdapterStub;
import org.eclipse.mddi.modelbus.description.concrete.Tool;

public class TransportManager {
    private static Logger logger;
    SessionManager sessionManager = new SessionManager();
    Map toolDesc_proxy = new Hashtable();
    AdapterStub adapter;
    Serializer serializer;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.mddi.modelbus.adapter.infrastructure.transport.TransportManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public TransportManager(AdapterStub adapter) {
        this.adapter = adapter;
    }

    public ProviderProxy getProviderProxy(Tool t) {
        ProviderProxy p = null;
        p = this.getWsInvocationSender(t);
        p.setToolDescription(t);
        if (this.serializer != null) {
            p.getMarshaler().setSerializer(this.serializer);
        }
        logger.debug((Object)("Marshaler:" + p.getMarshaler()));
        return p;
    }

    public SessionProviderProxy getSessionProviderProxy(Tool t) {
        DefaultSessionWsInvocationSender p = null;
        if (!DescriptionUtil.getIsSessionEnabled(t)) {
            return p;
        }
        p = AdapterContainerImpl.getInstance().containTool(t) ? new LocalSessionInvocationSender(this.adapter.getProperties()) : new DefaultSessionWsInvocationSender(this.adapter.getProperties());
        p.setSessionManager(this.sessionManager);
        p.setToolDescription(t);
        if (this.serializer != null) {
            p.getMarshaler().setSerializer(this.serializer);
        }
        return p;
    }

    public void removeProviderProxy(ProviderProxy p) {
        this.toolDesc_proxy.values().remove(p);
    }

    public Collection getAllProviderProxies() {
        return this.toolDesc_proxy.values();
    }

    private ProviderProxy getWsInvocationSender(Tool t) {
        String style = this.adapter.getProperties().getProperty("marshal.invocationStyle", "default");
        AbstractInvocationSender s = null;
        if (style.equals("default")) {
            if (AdapterContainerImpl.getInstance().containTool(t)) {
                logger.debug((Object)"Local Call");
                s = new LocalInvocationSender(this.adapter.getProperties());
            } else {
                s = new DefaultWsInvocationSender(this.adapter.getProperties());
            }
            return s;
        }
        s = new CopyRestoreFragmentWsInvocationSender(this.adapter.getProperties());
        return s;
    }

    public WsInvocationReceiver getWsInvocationReceiver() {
        DefaultWsInvocationReceiver r;
        String style = this.adapter.getProperties().getProperty("marshal.invocationStyle", "default");
        if (DescriptionUtil.getIsSessionEnabled(this.adapter.getToolDescription())) {
            r = new DefaultSessionWsInvocationReceiver(this.adapter);
        } else if (style.equals("default")) {
            r = new DefaultWsInvocationReceiver(this.adapter);
        } else {
            CopyRestoreFragmentWsInvocationReceiver r2 = new CopyRestoreFragmentWsInvocationReceiver(this.adapter);
            return r2;
        }
        if (this.serializer != null) {
            r.getMarshaler().setSerializer(this.serializer);
        }
        return r;
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public Serializer getSerializer() {
        return this.serializer;
    }

    public void setSerializer(Serializer serializer) {
        this.serializer = serializer;
    }
}

