/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.test.session;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.impl.EcorePackageImpl;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.ModelUtil;
import org.eclipse.mddi.modelbus.adapter.user.InvalidSession;
import org.eclipse.mddi.modelbus.adapter.user.ModelingServiceError;
import org.eclipse.mddi.modelbus.adapter.user.impl.AdapterStubImpl;
import org.eclipse.mddi.modelbus.adapter.user.provider.GenericSessionProvider;

public class SampleSessionTool
implements GenericSessionProvider {
    Collection model;
    EcoreFactory fac = EcorePackageImpl.init().getEcoreFactory();
    private static Logger logger;
    private static int sessionCounter;
    private static Vector sessions;
    private static Map session2packageName;
    public static boolean isStarted;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.mddi.modelbus.adapter.test.session.SampleSessionTool");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
        sessionCounter = 0;
        sessions = new Vector();
        session2packageName = new Hashtable();
        isStarted = false;
    }

    public Object[] executeSession(String serviceName, Object[] parameterValues, String sessionID) throws InvalidSession, ModelingServiceError {
        logger.info((Object)("Execute in session(" + sessionID + ")"));
        logger.info((Object)("Service name is [" + serviceName + "]"));
        logger.info((Object)("value [0] is " + parameterValues[0]));
        if (!sessions.contains(sessionID)) {
            throw new InvalidSession();
        }
        if (serviceName.equals("openPackage")) {
            String packageName = (String)parameterValues[0];
            session2packageName.put(sessionID, packageName);
            return new Object[0];
        }
        if (serviceName.equals("addNewClass")) {
            String newClassName = (String)parameterValues[0];
            this.model = (Collection)parameterValues[1];
            EClass c = this.fac.createEClass();
            c.setName(newClassName);
            EPackage pack = this.getPackage((String)session2packageName.get(sessionID));
            EList list = pack.getEClassifiers();
            list.add((Object)c);
            Object[] outputs = new Object[]{this.model};
            return outputs;
        }
        return null;
    }

    public EPackage getPackage(String packageName) throws ModelingServiceError {
        if (packageName == null) {
            throw new ModelingServiceError("Package is not yet open", (Object)this);
        }
        logger.debug((Object)("Package Name:" + packageName));
        EPackage p = (EPackage)ModelUtil.findElementByName((Collection)this.model, (String)packageName);
        if (p == null) {
            p = this.fac.createEPackage();
            p.setName(packageName);
            this.model.add(p);
        }
        return p;
    }

    public String newSession() {
        String sessionId = new Integer(++sessionCounter).toString();
        sessions.add(sessionId);
        logger.info((Object)("New session is started ID=" + sessionId));
        return sessionId;
    }

    public void endSession(String sessionID) throws InvalidSession {
        if (!sessions.contains(sessionID)) {
            throw new InvalidSession();
        }
        logger.info((Object)("End for session with ID=" + sessionID));
    }

    public static void main(String[] args) {
        if (isStarted) {
            return;
        }
        String registry_loc = args.length > 0 ? args[0] : "http://localhost:8082/modelbus/modelwareRegistry";
        String desc_file = args.length > 1 ? args[1] : "./src/org/eclipse/mddi/modelbus/adapter/test/session/session_tool.description";
        try {
            Properties p = new Properties();
            p.put("registry_location", registry_loc);
            p.put("tool_desc_file", desc_file);
            AdapterStubImpl adapter = new AdapterStubImpl(p);
            SampleSessionTool provider = new SampleSessionTool();
            adapter.getToolStub().setSessionProvider((GenericSessionProvider)provider);
            adapter.deploy();
            logger.info((Object)"Session tool is available");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
    }
}

