/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation;

import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

public abstract class ModelWrapper {
    public static final Map registries = new Hashtable();

    public abstract EObject wrapModelElement(Object var1);

    public abstract Object unwrapModelElement(EObject var1);

    public abstract boolean canWrap(Object var1);

    public abstract boolean canUnwrap(Object var1);

    public abstract EObject create(EClass var1);

    public static void addRegistry(String format, ModelWrapper r) {
        registries.put(format, r);
    }

    public static ModelWrapper getRegistry(String format) {
        return (ModelWrapper)registries.get(format);
    }

    public static Collection wrap(Collection c) {
        if (c == null) {
            return null;
        }
        HashSet<EObject> l = new HashSet<EObject>();
        if (c.isEmpty()) {
            return new HashSet();
        }
        ModelWrapper reg = null;
        Object o1 = c.iterator().next();
        if (o1 instanceof EObject) {
            return new HashSet(c);
        }
        Iterator<Object> it = registries.values().iterator();
        while (it.hasNext()) {
            ModelWrapper r = (ModelWrapper)it.next();
            if (!r.canWrap(o1)) continue;
            reg = r;
            break;
        }
        if (reg == null) {
            throw new RuntimeException("No wrapper for type " + c.iterator().next().getClass());
        }
        it = c.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            l.add(reg.wrapModelElement(o));
        }
        return l;
    }

    public static Collection unwrap(Collection c) {
        if (c == null) {
            return null;
        }
        Vector<Object> l = new Vector<Object>();
        if (c.isEmpty()) {
            return l;
        }
        ModelWrapper reg = null;
        Object o1 = c.iterator().next();
        Iterator<Object> it = registries.values().iterator();
        while (it.hasNext()) {
            ModelWrapper r = (ModelWrapper)it.next();
            if (!r.canUnwrap(o1)) continue;
            reg = r;
            break;
        }
        if (reg == null) {
            throw new RuntimeException("No wrapper for type " + c.iterator().next().getClass());
        }
        it = c.iterator();
        while (it.hasNext()) {
            Object o = reg.unwrapModelElement((EObject)it.next());
            l.add(o);
        }
        return l;
    }
}

