/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.registry;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.mddi.modelbus.adapter.infrastructure.registry.RegistryClient;
import org.eclipse.mddi.modelbus.adapter.infrastructure.registry.RegistryNotAvailableException;
import org.eclipse.mddi.modelbus.adapter.user.AdapterStub;
import org.eclipse.mddi.modelbus.adapter.user.consumer.ModelBusCommunicationException;
import org.eclipse.mddi.modelbus.adapter.user.consumer.ServiceUnknownException;
import org.eclipse.mddi.modelbus.description.concrete.Tool;

public class RegistryManager {
    static RegistryManager instance = new RegistryManager();
    Map clientMap = new HashMap();

    public static RegistryManager getInstance() {
        return instance;
    }

    public void registerTool(AdapterStub adapter) throws RegistryNotAvailableException {
        Tool toolDescription = adapter.getToolDescription();
        if (toolDescription == null) {
            return;
        }
        String registry_location = adapter.getProperties().getProperty("registry_location");
        if (registry_location == null) {
            throw new RegistryNotAvailableException("No registry_location specified");
        }
        RegistryClient registryClient = this.getRegistryClient(registry_location);
        String token = registryClient.registerTool(toolDescription);
        if (token == null) {
            return;
        }
        adapter.getProperties().setProperty("registry_token", token);
    }

    public void deregisterTool(AdapterStub adapter) throws RegistryNotAvailableException {
        String token = adapter.getProperties().getProperty("registry_token");
        if (token == null) {
            return;
        }
        String registry_location = adapter.getProperties().getProperty("registry_location");
        RegistryClient registryClient = RegistryManager.getInstance().getRegistryClient(registry_location);
        registryClient.deregisterTool(token);
    }

    public Tool getToolDescription(String serviceName, AdapterStub adapter) throws ModelBusCommunicationException, ServiceUnknownException {
        Tool toolDescription = null;
        try {
            RegistryClient c = RegistryManager.getInstance().getRegistryClient(adapter.getProperties().getProperty("registry_location"));
            toolDescription = c.lookupToolByModelingService(serviceName, adapter.getToolSelector());
        }
        catch (RegistryNotAvailableException e) {
            throw new ModelBusCommunicationException(e.toString());
        }
        if (toolDescription == null) {
            throw new ServiceUnknownException(serviceName);
        }
        return toolDescription;
    }

    public Collection getAllRegistryLocations() {
        return new HashSet(this.clientMap.keySet());
    }

    public Collection getAllRegistryClients() {
        return new HashSet(this.clientMap.values());
    }

    public RegistryClient getRegistryClient(String location) throws RegistryNotAvailableException {
        if (this.clientMap.containsKey(location)) {
            RegistryClient client = (RegistryClient)this.clientMap.get(location);
            return client;
        }
        RegistryClient client = new RegistryClient(location);
        this.clientMap.put(location, client);
        return client;
    }

    public void removeRegistryClient(String location) {
        if (this.clientMap.containsKey(location)) {
            this.clientMap.remove(location);
        }
    }
}

