/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.test.unit;

import java.util.Collection;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPMessage;
import junit.framework.Assert;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.apache.log4j.Logger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.LoggerConfigurator;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.marshal.ws.DefaultMarshaler;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.marshal.ws.SoapUtil;
import org.eclipse.mddi.modelbus.adapter.test.unit.Util;
import org.eclipse.mddi.modelbus.description.abstract_.AbstractFactory;
import org.eclipse.mddi.modelbus.description.abstract_.ModelType;
import org.eclipse.mddi.modelbus.description.abstract_.Parameter;
import org.eclipse.mddi.modelbus.description.abstract_.PrimitiveType;
import org.eclipse.mddi.modelbus.description.abstract_.Type;
import org.eclipse.mddi.modelbus.description.abstract_.impl.AbstractPackageImpl;

public class MarshallTest
extends TestCase {
    private static Logger logger;
    private static DefaultMarshaler marshaler;
    SOAPMessage msg;
    SOAPElement topElem;
    AbstractFactory factory;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.mddi.modelbus.adapter.test.unit.MarshallTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
        marshaler = new DefaultMarshaler(null);
    }

    public static void main(String[] args) {
        LoggerConfigurator.configure();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.mddi.modelbus.adapter.test.unit.MarshallTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
    }

    protected void setUp() throws Exception {
        try {
            this.msg = SoapUtil.messageFactory.createMessage();
            SOAPBody body = this.msg.getSOAPBody();
            DefaultMarshaler.setNamespaces((SOAPBody)body);
            this.topElem = body.addChildElement("service1", "modelbus");
            this.factory = AbstractPackageImpl.init().getAbstractFactory();
        }
        catch (Exception e) {
            throw new Exception("TestCase can not be initialized", e);
        }
    }

    protected void tearDown() throws Exception {
    }

    public void testMarshall_string() throws Exception {
        Parameter p = this.factory.createParameter();
        p.setName("p1");
        PrimitiveType t = this.factory.createPrimitiveType();
        t.setName("string");
        p.setType((Type)t);
        String parameterValue = "test string";
        this.topElem.removeContents();
        marshaler.marshal(p, (Object)parameterValue, this.topElem);
        logger.info((Object)"testMarshall_string");
        logger.info((Object)("marshall result = \n" + this.topElem + "\n"));
        Object unmarshalledParam = marshaler.unmarshal(p, this.topElem);
        Assert.assertEquals((Object)parameterValue, (Object)unmarshalledParam);
    }

    public void testMarshall_string_array() throws Exception {
        Parameter p = this.factory.createParameter();
        p.setName("p1");
        p.setUpper(-1);
        PrimitiveType t = this.factory.createPrimitiveType();
        t.setName("string");
        p.setType((Type)t);
        String[] parameterValue = new String[]{"string1", "string2", "string3"};
        this.topElem.removeContents();
        marshaler.marshal(p, (Object)parameterValue, this.topElem);
        logger.info((Object)"testMarshall_string_array");
        logger.info((Object)("marshall result = \n" + this.topElem + "\n"));
        String[] unmarshalledParam = (String[])marshaler.unmarshal(p, this.topElem);
        int i = 0;
        while (i < parameterValue.length) {
            Assert.assertEquals((String)parameterValue[i], (String)unmarshalledParam[i]);
            ++i;
        }
    }

    public void testMarshall_boulean_array() throws Exception {
        Parameter p = this.factory.createParameter();
        p.setName("p1");
        p.setUpper(-1);
        PrimitiveType t = this.factory.createPrimitiveType();
        t.setName("boolean");
        p.setType((Type)t);
        Boolean[] parameterValue = new Boolean[]{new Boolean(true), new Boolean(false), new Boolean(false)};
        this.topElem.removeContents();
        marshaler.marshal(p, (Object)parameterValue, this.topElem);
        logger.info((Object)"testMarshall_boolean_array");
        logger.info((Object)("marshall result = \n" + this.topElem + "\n"));
        Boolean[] unmarshalledParam = (Boolean[])marshaler.unmarshal(p, this.topElem);
        int i = 0;
        while (i < parameterValue.length) {
            Assert.assertEquals((Object)parameterValue[i], (Object)unmarshalledParam[i]);
            ++i;
        }
    }

    public void testMarshall_int_array() throws Exception {
        Parameter p = this.factory.createParameter();
        p.setName("p1");
        p.setUpper(-1);
        PrimitiveType t = this.factory.createPrimitiveType();
        t.setName("integer");
        p.setType((Type)t);
        Integer[] parameterValue = new Integer[]{new Integer(456), new Integer(789), new Integer(687)};
        this.topElem.removeContents();
        marshaler.marshal(p, (Object)parameterValue, this.topElem);
        logger.info((Object)"testMarshall_int_array");
        logger.info((Object)("marshall result = \n" + this.topElem + "\n"));
        Integer[] unmarshalledParam = (Integer[])marshaler.unmarshal(p, this.topElem);
        int i = 0;
        while (i < parameterValue.length) {
            Assert.assertEquals((Object)parameterValue[i], (Object)unmarshalledParam[i]);
            ++i;
        }
    }

    public void testMarshall_double_array() throws Exception {
        Parameter p = this.factory.createParameter();
        p.setName("p1");
        p.setUpper(-1);
        PrimitiveType t = this.factory.createPrimitiveType();
        t.setName("double");
        p.setType((Type)t);
        Double[] parameterValue = new Double[]{new Double(456.757), new Double(789.757), new Double(687.757)};
        this.topElem.removeContents();
        marshaler.marshal(p, (Object)parameterValue, this.topElem);
        logger.info((Object)"testMarshall_double_array");
        logger.info((Object)("marshall result = \n" + this.topElem + "\n"));
        Double[] unmarshalledParam = (Double[])marshaler.unmarshal(p, this.topElem);
        int i = 0;
        while (i < parameterValue.length) {
            Assert.assertEquals((Object)parameterValue[i], (Object)unmarshalledParam[i]);
            ++i;
        }
    }

    public void testMarshall_model_array() throws Exception {
        Parameter p = this.factory.createParameter();
        p.setName("p1");
        p.setUpper(-1);
        ModelType t = this.factory.createModelType();
        p.setType((Type)t);
        Collection[] parameterValue = new Collection[]{Util.createUml2Model(), Util.createUml2Model(), Util.createUml2Model()};
        this.topElem.removeContents();
        marshaler.marshal(p, (Object)parameterValue, this.topElem);
        logger.info((Object)"testMarshall_model_array");
        logger.info((Object)("marshall result = \n" + this.topElem + "\n"));
        Collection[] unmarshalledParam = (Collection[])marshaler.unmarshal(p, this.topElem);
        int i = 0;
        while (i < parameterValue.length) {
            Assert.assertTrue((boolean)Util.compareModels(parameterValue[i], unmarshalledParam[i]));
            ++i;
        }
    }

    public void testMarshall_null() throws Exception {
        Parameter p = this.factory.createParameter();
        p.setName("p1");
        PrimitiveType t = this.factory.createPrimitiveType();
        t.setName("boolean");
        p.setType((Type)t);
        Object parameterValue = null;
        this.topElem.removeContents();
        marshaler.marshal(p, parameterValue, this.topElem);
        logger.info((Object)"testMarshall_null");
        logger.info((Object)("marshall result = \n" + this.topElem + "\n"));
        Object unmarshalledParam = marshaler.unmarshal(p, this.topElem);
        Assert.assertEquals(parameterValue, (Object)unmarshalledParam);
    }

    public void testMarshall_boolean() throws Exception {
        Parameter p = this.factory.createParameter();
        p.setName("p1");
        PrimitiveType t = this.factory.createPrimitiveType();
        t.setName("boolean");
        p.setType((Type)t);
        Boolean parameterValue = new Boolean(true);
        this.topElem.removeContents();
        marshaler.marshal(p, (Object)parameterValue, this.topElem);
        logger.info((Object)"testMarshall_boolean");
        logger.info((Object)("marshall result = \n" + this.topElem + "\n"));
        Object unmarshalledParam = marshaler.unmarshal(p, this.topElem);
        Assert.assertEquals((Object)parameterValue, (Object)unmarshalledParam);
    }

    public void testMarshall_int() throws Exception {
        Parameter p = this.factory.createParameter();
        p.setName("p1");
        PrimitiveType t = this.factory.createPrimitiveType();
        t.setName("integer");
        p.setType((Type)t);
        Integer parameterValue = new Integer(456573);
        this.topElem.removeContents();
        marshaler.marshal(p, (Object)parameterValue, this.topElem);
        logger.info((Object)"testMarshall_boolean");
        logger.info((Object)("marshall result = \n" + this.topElem + "\n"));
        Object unmarshalledParam = marshaler.unmarshal(p, this.topElem);
        Assert.assertEquals((Object)parameterValue, (Object)unmarshalledParam);
    }

    public void testMarshall_double() throws Exception {
        Parameter p = this.factory.createParameter();
        p.setName("p1");
        PrimitiveType t = this.factory.createPrimitiveType();
        t.setName("double");
        p.setType((Type)t);
        Double parameterValue = new Double(456573.646546);
        this.topElem.removeContents();
        marshaler.marshal(p, (Object)parameterValue, this.topElem);
        logger.info((Object)"testMarshall_boolean");
        logger.info((Object)("marshall result = \n" + this.topElem + "\n"));
        Object unmarshalledParam = marshaler.unmarshal(p, this.topElem);
        Assert.assertEquals((Object)parameterValue, (Object)unmarshalledParam);
    }

    public void testMarshall_model() throws Exception {
        Parameter p = this.factory.createParameter();
        p.setName("p1");
        ModelType t = this.factory.createModelType();
        p.setType((Type)t);
        Collection parameterValue = Util.createUml2Model();
        logger.info((Object)("Size of model1:" + parameterValue.size()));
        this.topElem.removeContents();
        marshaler.marshal(p, (Object)parameterValue, this.topElem);
        logger.info((Object)"testMarshall_model");
        Collection unmarshalledParam = (Collection)marshaler.unmarshal(p, this.topElem);
        logger.info((Object)("Size of model2:" + unmarshalledParam.size()));
        logger.info((Object)("Compare result:" + Util.compareModels(parameterValue, unmarshalledParam)));
        Assert.assertTrue((boolean)Util.compareModels(parameterValue, unmarshalledParam));
    }
}

