/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.test.anno;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.impl.EcorePackageImpl;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.emf_xmi.Emf2XmiConversion;
import org.eclipse.mddi.modelbus.adapter.test.registry.BasicRegistry;
import org.eclipse.mddi.modelbus.adapter.user.ModelingServiceError;
import org.eclipse.mddi.modelbus.adapter.user.SessionNeeded;
import org.eclipse.mddi.modelbus.adapter.user.impl.AdapterStubImpl;
import org.eclipse.mddi.modelbus.adapter.user.provider.GenericProvider;
import org.eclipse.uml2.NamedElement;
import org.eclipse.uml2.Package;
import org.eclipse.uml2.impl.UML2PackageImpl;

public class Provider {
    public static String REG = BasicRegistry.getUrl();
    static EcoreFactory ef = EcorePackageImpl.init().getEcoreFactory();

    public static void main(String[] args) throws Exception {
        UML2PackageImpl.init();
        BasicRegistry.start();
        Properties p = new Properties();
        p.put("registry_location", REG);
        p.put("tool_desc_file", "./src/org/eclipse/mddi/modelbus/adapter/test/anno/inoutModelService.description");
        AdapterStubImpl stub = new AdapterStubImpl(p);
        stub.getToolStub().setProvider((GenericProvider)new MyTool());
        stub.deploy();
    }

    static void showResult(Collection model) throws IOException {
        System.out.println("Result:");
        System.out.println(Emf2XmiConversion.convertToString((Collection)model));
    }

    static void updateModel(Collection model) {
        Package p = (Package)model.iterator().next();
        int i = 0;
        Iterator it = p.getOwnedElements().iterator();
        while (it.hasNext()) {
            NamedElement e = (NamedElement)it.next();
            EAnnotation anno = ef.createEAnnotation();
            anno.setSource("provider:annotation" + i + "=" + i);
            e.getEAnnotations().add((Object)anno);
            ++i;
        }
    }

    static class MyTool
    implements GenericProvider {
        MyTool() {
        }

        public Object[] execute(String serviceName, Object[] parameterValues) throws SessionNeeded, ModelingServiceError {
            Collection model = (Collection)parameterValues[0];
            try {
                Provider.showResult(model);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            Provider.updateModel(model);
            Object[] result = new Object[]{model};
            return result;
        }
    }
}

