/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.test.asynchronous;

import java.io.IOException;
import java.util.Collection;
import java.util.Properties;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.emf_xmi.Emf2XmiConversion;
import org.eclipse.mddi.modelbus.adapter.test.asynchronous.ConsumerAsyncTest;
import org.eclipse.mddi.modelbus.adapter.test.registry.BasicRegistry;
import org.eclipse.mddi.modelbus.adapter.user.AdapterStub;
import org.eclipse.mddi.modelbus.adapter.user.impl.AdapterStubImpl;

public class AsyncSessionConsumer {
    public static final String ADD_CLASS = "SampleSessionTool.interface1.addNewClass";
    public static final String OPEN_PACK = "SampleSessionTool.interface1.openPackage";
    private static Logger logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.mddi.modelbus.adapter.test.asynchronous.AsyncSessionConsumer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public static String modelToString(Collection model) {
        String result = new String();
        try {
            result = Emf2XmiConversion.convertToString((Collection)model);
            return String.valueOf(result) + "\n Test has successfully finished.";
        }
        catch (IOException iOException) {
            return "ERROR";
        }
    }

    public static void addClass(String className, Collection model, String sessionId, AdapterStub adapter) throws Exception {
        Object[] inputs = new Object[]{className, model};
        ConsumerAsyncTest test = new ConsumerAsyncTest(adapter, ADD_CLASS, inputs);
        String connexionId = test.consumeAsync(sessionId);
        while (!test.isResultReady(connexionId)) {
            logger.info((Object)"result not ready");
            Thread.sleep(1L);
        }
        logger.info((Object)"result ready");
        Object[] outputs = test.getResult(connexionId);
        int i = 0;
        while (i < outputs.length) {
            Object object = outputs[i];
            logger.info((Object)(" outputs[" + i + "] = " + object));
            ++i;
        }
        model = (Collection)outputs[0];
    }

    public static void main(String[] args) {
        Vector model = new Vector();
        String registry_loc = args.length > 0 ? args[0] : BasicRegistry.getUrl();
        logger.info((Object)("Registry location is:" + registry_loc));
        try {
            Properties p = new Properties();
            p.put("registry_location", registry_loc);
            AdapterStubImpl adapter = new AdapterStubImpl(p);
            Object[] inputs = new Object[]{"Pack2"};
            ConsumerAsyncTest testAddClass = new ConsumerAsyncTest((AdapterStub)adapter, ADD_CLASS, inputs);
            ConsumerAsyncTest testOpenPack = new ConsumerAsyncTest((AdapterStub)adapter, OPEN_PACK, inputs);
            String sessionId = testAddClass.openSession();
            String connexionId = testOpenPack.consumeAsync(sessionId);
            while (!testOpenPack.isResultReady(connexionId)) {
                logger.info((Object)"result not ready");
                Thread.sleep(1L);
            }
            logger.info((Object)"result ready");
            Object[] outputs = testOpenPack.getResult(connexionId);
            int i = 0;
            while (i < outputs.length) {
                Object object = outputs[i];
                logger.info((Object)(" outputs[" + i + "] = " + object));
                ++i;
            }
            AsyncSessionConsumer.addClass("class A-1", model, sessionId, (AdapterStub)adapter);
            testAddClass.closeSession(sessionId);
            logger.info((Object)("Result:" + AsyncSessionConsumer.modelToString(model)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

