/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure;

import java.net.MalformedURLException;
import java.util.Collection;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.AdapterContainer;
import org.eclipse.mddi.modelbus.adapter.infrastructure.DeploymentException;
import org.eclipse.mddi.modelbus.adapter.infrastructure.LoggerConfigurator;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.DescriptionUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.notification.NotifServiceManager;
import org.eclipse.mddi.modelbus.adapter.infrastructure.notification.NotifServiceNotAvailableException;
import org.eclipse.mddi.modelbus.adapter.infrastructure.registry.RegistryManager;
import org.eclipse.mddi.modelbus.adapter.infrastructure.registry.RegistryNotAvailableException;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.server.ws.ProviderEndPoint;
import org.eclipse.mddi.modelbus.adapter.user.AdapterStub;
import org.eclipse.mddi.modelbus.description.concrete.Tool;

public class AdapterContainerImpl
implements AdapterContainer {
    private static AdapterContainerImpl instance = new AdapterContainerImpl();
    public static Logger logger;
    ProviderEndPoint msProviderEndPoint = new ProviderEndPoint();
    Collection adapters = this.msProviderEndPoint.getAdapters();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.mddi.modelbus.adapter.infrastructure.AdapterContainerImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public static AdapterContainer getInstance() {
        LoggerConfigurator.configure();
        return instance;
    }

    private AdapterContainerImpl() {
        Runtime.getRuntime().addShutdownHook(new AdapterContainerShutdown());
    }

    public void deployAdapter(AdapterStub adapter) throws DeploymentException {
        DeploymentException exception = new DeploymentException();
        try {
            if (adapter.getToolDescription() != null) {
                this.msProviderEndPoint.manageAdapter(adapter);
            }
        }
        catch (MalformedURLException e) {
            exception.addProblem("Bad tool URL in tool description", e);
            logger.debug((Object)"Bad tool URL in tool description ");
        }
        catch (Exception e) {
            exception.addProblem("Could not deploy Tool to Server", e);
            logger.debug((Object)"Could not deploy Tool to Server", (Throwable)e);
        }
        try {
            if (adapter.getToolDescription() != null) {
                logger.debug((Object)"Registering Tool: ");
                RegistryManager.getInstance().registerTool(adapter);
            }
        }
        catch (RegistryNotAvailableException e) {
            exception.addProblem("Could not register tool", e);
            logger.debug((Object)"Could not register tool", (Throwable)e);
        }
        try {
            NotifServiceManager.getInstance().subscribeNotificationConsumer(adapter);
        }
        catch (NotifServiceNotAvailableException e) {
            exception.addProblem("Could not subscribe NotificationConsumer", e);
            logger.debug((Object)"Could not subscribe NotificationConsumer", (Throwable)e);
        }
        if (exception.hasProblems()) {
            logger.debug((Object)exception.toString());
            throw exception;
        }
    }

    public void undeployAdapter(AdapterStub adapter) throws DeploymentException {
        DeploymentException exception = new DeploymentException();
        try {
            this.msProviderEndPoint.removeAdapter(adapter);
            this.adapters.remove(adapter);
        }
        catch (Exception e) {
            exception.addProblem("Could not unbind tool", e);
            logger.debug((Object)"Could not unbind tool", (Throwable)e);
        }
        try {
            RegistryManager.getInstance().deregisterTool(adapter);
        }
        catch (RegistryNotAvailableException e) {
            exception.addProblem("Could not register tool", e);
            logger.debug((Object)"Could not register tool", (Throwable)e);
        }
        try {
            NotifServiceManager.getInstance().unsubscribeNotificationConsumer(adapter);
        }
        catch (NotifServiceNotAvailableException e) {
            exception.addProblem("Could not unsubscribe NotificationConsumer", e);
            logger.debug((Object)"Could not unsubscribe NotificationConsumer", (Throwable)e);
        }
        if (exception.hasProblems()) {
            logger.debug((Object)exception.toString());
            throw exception;
        }
    }

    public boolean containsTool(Tool toolDesc) {
        Iterator it = this.adapters.iterator();
        while (it.hasNext()) {
            AdapterStub adapter = (AdapterStub)it.next();
            Tool testTool = adapter.getToolDescription();
            if (!DescriptionUtil.isToolEqual(testTool, toolDesc)) continue;
            return true;
        }
        return false;
    }

    public Collection getAdapters() {
        return this.adapters;
    }

    class AdapterContainerShutdown
    extends Thread {
        AdapterContainerShutdown() {
        }

        public void run() {
            Collection adapters = AdapterContainerImpl.getInstance().getAdapters();
            Iterator it = adapters.iterator();
            while (it.hasNext()) {
                AdapterStub adapter = (AdapterStub)it.next();
                try {
                    AdapterContainerImpl.getInstance().undeployAdapter(adapter);
                }
                catch (DeploymentException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

