/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.merge;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.AbstractConflictHandler;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.ConflictDetection;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.DeltaApplication;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.DeltaQuery;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.MergeData;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.BasicConflictResolution;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.Conflict;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.Create;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.Delete;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.Delta;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.InsertLink;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.Merge;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.ModifyExisting;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.ModifyLink;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.ModifyPrimitive;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.ModifyProp;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.NodeLevelSubDelta;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.RemoveLink;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.SubDelta;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.modelbus_xmi.MBXmiResource;

public class BasicConflictHandler
extends AbstractConflictHandler {
    protected BasicConflictResolution res;
    Delta newLocalDelta;
    Delta newRemoteDelta;
    Collection conflicts;

    public static boolean isAllCanceled(List l) {
        if (l.isEmpty()) {
            return true;
        }
        Merge m = DeltaQuery.getMerge((SubDelta)l.get(0));
        if (m == null) {
            return false;
        }
        BasicConflictResolution r = (BasicConflictResolution)m.getResolution();
        if (r == null) {
            return false;
        }
        int i = 0;
        while (i < l.size()) {
            SubDelta d = (SubDelta)l.get(i);
            if (!BasicConflictHandler.isCanceled(d, r)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isCanceled(SubDelta d, BasicConflictResolution r) {
        if (r == null) {
            return false;
        }
        return r.getCanceledSubDelta().contains((Object)d);
    }

    public static boolean isCanceled(SubDelta d) {
        Merge m = DeltaQuery.getMerge(d);
        if (m == null) {
            return false;
        }
        return BasicConflictHandler.isCanceled(d, (BasicConflictResolution)m.getResolution());
    }

    public static boolean isAllCanceled(Collection c, BasicConflictResolution r) {
        if (r == null) {
            return false;
        }
        return r.getCanceledSubDelta().containsAll(c);
    }

    public static boolean isAllCanceled(Collection c) {
        if (c.isEmpty()) {
            return true;
        }
        SubDelta d = (SubDelta)c.iterator().next();
        Merge m = DeltaQuery.getMerge(d);
        if (m == null) {
            return false;
        }
        return BasicConflictHandler.isAllCanceled(c, (BasicConflictResolution)m.getResolution());
    }

    public static void chooseLocal(Conflict conf) {
        BasicConflictResolution r = (BasicConflictResolution)AbstractConflictHandler.getResolution(conf);
        r.getCanceledSubDelta().removeAll((Collection)conf.getLocal());
        r.getCanceledSubDelta().addAll((Collection)conf.getRemote());
    }

    public static void chooseRemote(Conflict conf) {
        BasicConflictResolution r = (BasicConflictResolution)AbstractConflictHandler.getResolution(conf);
        r.getCanceledSubDelta().removeAll((Collection)conf.getRemote());
        r.getCanceledSubDelta().addAll((Collection)conf.getLocal());
    }

    public static Delta getNewDelta(Delta old, Collection canceled) {
        Delta d2 = AbstractConflictHandler.fac.createDelta();
        Iterator it = old.getContent().iterator();
        while (it.hasNext()) {
            NodeLevelSubDelta nl = (NodeLevelSubDelta)it.next();
            if (canceled.contains(nl)) continue;
            NodeLevelSubDelta nl2 = (NodeLevelSubDelta)EcoreUtil.create((EClass)nl.eClass());
            nl2.setId(nl.getId());
            if (nl instanceof Create) {
                Create c2 = (Create)nl2;
                c2.setType(((Create)nl).getType());
                d2.getContent().add((Object)nl2);
            }
            if (nl instanceof Delete) {
                d2.getContent().add((Object)nl2);
            }
            Iterator it2 = nl.getContent().iterator();
            while (it2.hasNext()) {
                ModifyProp modProp = (ModifyProp)it2.next();
                if (canceled.contains(modProp)) continue;
                ModifyProp modProp2 = (ModifyProp)EcoreUtil.create((EClass)modProp.eClass());
                modProp2.setProperty(modProp.getProperty());
                if (modProp instanceof ModifyPrimitive) {
                    ((ModifyPrimitive)modProp2).setValue(((ModifyPrimitive)modProp).getValue());
                    nl2.getContent().add((Object)modProp2);
                    continue;
                }
                if (!(modProp instanceof ModifyLink)) continue;
                ModifyLink ml = (ModifyLink)modProp;
                ModifyLink ml2 = (ModifyLink)modProp2;
                if (ml.getRemove() != null && !canceled.contains(ml.getRemove())) {
                    RemoveLink rl2 = AbstractConflictHandler.fac.createRemoveLink();
                    rl2.getRef().addAll((Collection)ml.getRemove().getRef());
                    ml2.setRemove(rl2);
                }
                Iterator it3 = ml.getInsert().iterator();
                while (it3.hasNext()) {
                    InsertLink il = (InsertLink)it3.next();
                    if (canceled.contains(il)) continue;
                    InsertLink il2 = AbstractConflictHandler.fac.createInsertLink();
                    il2.setPosAfter(il.getPosAfter());
                    il2.getRef().addAll((Collection)il.getRef());
                    ml2.getInsert().add((Object)il2);
                }
                if (ml2.getRemove() == null && ml2.getInsert().isEmpty()) continue;
                nl2.getContent().add((Object)modProp2);
            }
            if (!(nl2 instanceof ModifyExisting) || nl2.getContent().isEmpty()) continue;
            d2.getContent().add((Object)nl2);
        }
        return d2;
    }

    public void start(MergeData mergeData) {
        super.start(mergeData);
        Merge m = mergeData.getMergeModel();
        if (!(m.getResolution() instanceof BasicConflictResolution)) {
            this.res = AbstractConflictHandler.fac.createBasicConflictResolution();
            m.setResolution(this.res);
        } else {
            this.res = (BasicConflictResolution)m.getResolution();
        }
    }

    public Collection testFinish() {
        HashSet canceled = new HashSet(this.res.getCanceledSubDelta());
        this.newLocalDelta = BasicConflictHandler.getNewDelta(this.mergeData.getMergeModel().getLocalDelta(), canceled);
        this.newRemoteDelta = BasicConflictHandler.getNewDelta(this.mergeData.getMergeModel().getRemoteDelta(), canceled);
        this.conflicts = ConflictDetection.recheck(this.newLocalDelta, this.newRemoteDelta, this.mergeData.getBaseVariant());
        if (this.conflicts.isEmpty()) {
            this.finished = true;
        }
        return this.conflicts;
    }

    public Resource getResult() {
        if (!this.finished) {
            return null;
        }
        MBXmiResource r = this.mergeData.getBaseVariant();
        if (r == null) {
            return null;
        }
        DeltaApplication da = new DeltaApplication(r);
        da.apply(this.newLocalDelta);
        da.apply(this.newRemoteDelta);
        return r;
    }
}

