/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.merge;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.ConflictDetectionHelper;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.DeltaQuery;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.MergeData;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.Conflict;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.ConflictSet;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.Create;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.Delete;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.Delta;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.InsertLink;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.MergeFactory;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.ModifyExisting;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.ModifyLink;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.ModifyPrimitive;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.NodeLevelSubDelta;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.impl.MergePackageImpl;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.util.SimpleModelLabelProvider;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.modelbus_xmi.MBXmiResource;

public class ConflictDetection {
    static MergeFactory fac = MergePackageImpl.init().getMergeFactory();
    static Logger logger = Logger.getLogger((String)"ConflictDetection");
    public static String DELETE_UPDATE = "DeleteUpdate";
    public static String DANGLING_LINK = "DanglingLink";
    public static String CONCURRENT_UPDATE_PRIMITIVE = "ConcurrentUpdatePrimitive";
    public static String ORDER_CONFLICT = "OrderConflict";
    public static String MUL_CONFLICT = "MultiplicityConflict";
    MBXmiResource baseVariant;
    DeltaQuery localQuery;
    DeltaQuery remoteQuery;
    List conflicts;

    public static void firstCheck(MergeData mergeData) {
        DeltaQuery localQuery = new DeltaQuery(mergeData.getMergeModel().getLocalDelta());
        DeltaQuery remoteQuery = new DeltaQuery(mergeData.getMergeModel().getRemoteDelta());
        ConflictDetectionHelper.changeConflictingIDs(mergeData, localQuery, remoteQuery);
        ConflictDetection cd = new ConflictDetection(localQuery, remoteQuery, mergeData.getBaseVariant());
        List conflicts = cd.detect();
        ConflictSet conflictSet = fac.createConflictSet();
        conflictSet.getElement().addAll((Collection)conflicts);
        mergeData.getMergeModel().setConflict(conflictSet);
    }

    public static List recheck(Delta local, Delta remote, MBXmiResource base) {
        DeltaQuery localQuery = new DeltaQuery(local);
        DeltaQuery remoteQuery = new DeltaQuery(remote);
        ConflictDetection cd = new ConflictDetection(localQuery, remoteQuery, base);
        return cd.detect();
    }

    ConflictDetection(DeltaQuery local, DeltaQuery remote, MBXmiResource base) {
        this.localQuery = local;
        local.getDelta().setLocal(true);
        this.remoteQuery = remote;
        remote.getDelta().setLocal(false);
        this.baseVariant = base;
    }

    List detect() {
        this.conflicts = new Vector();
        this.detectDeleteModify();
        this.detectConcurrentModify();
        this.detectOrderConflict();
        this.detectDanglingLink();
        this.detectMultiplicityViolation();
        return this.conflicts;
    }

    void detectDeleteModify() {
        this.detectDeleteModify(this.localQuery, this.remoteQuery);
        this.detectDeleteModify(this.remoteQuery, this.localQuery);
    }

    void detectDeleteModify(DeltaQuery deleter, DeltaQuery modifier) {
        Iterator it = deleter.getDelta().getContent().iterator();
        while (it.hasNext()) {
            Delete delete;
            Conflict conf;
            Object o = it.next();
            if (!(o instanceof Delete) || (conf = ConflictDetectionHelper.detectDeleteUpdate(modifier, delete = (Delete)o)) == null) continue;
            this.conflicts.add(conf);
        }
    }

    void detectConcurrentModify() {
        Iterator it = this.localQuery.getDelta().getContent().iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof ModifyExisting)) continue;
            ModifyExisting mod = (ModifyExisting)o;
            Iterator it2 = mod.getContent().iterator();
            while (it2.hasNext()) {
                ModifyPrimitive mp;
                Conflict conf;
                Object o2 = it2.next();
                if (!(o2 instanceof ModifyPrimitive) || (conf = ConflictDetectionHelper.detectConcurrentUpdatePrimitive(this.remoteQuery, mp = (ModifyPrimitive)o2)) == null) continue;
                this.conflicts.add(conf);
            }
        }
    }

    void detectOrderConflict() {
        Iterator it = this.localQuery.getDelta().getContent().iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof ModifyExisting)) continue;
            ModifyExisting mod = (ModifyExisting)o;
            Iterator it2 = mod.getContent().iterator();
            while (it2.hasNext()) {
                Conflict conf;
                ModifyLink ml;
                Object o2 = it2.next();
                if (!(o2 instanceof ModifyLink) || !((EReference)(ml = (ModifyLink)o2).getProperty()).isOrdered()) continue;
                Iterator it3 = ml.getInsert().iterator();
                while (it3.hasNext()) {
                    InsertLink il = (InsertLink)it3.next();
                    Conflict conf2 = ConflictDetectionHelper.detectOrderConflict(this.remoteQuery, il);
                    if (conf2 == null) continue;
                    this.conflicts.add(conf2);
                }
                if (ml.getRemove() == null || (conf = ConflictDetectionHelper.detectOrderConflict(this.remoteQuery, ml.getRemove())) == null) continue;
                this.conflicts.add(conf);
            }
        }
    }

    void detectDanglingLink() {
        this.detectDanglingLink(this.localQuery, this.remoteQuery, true);
        this.detectDanglingLink(this.remoteQuery, this.localQuery, false);
    }

    void detectDanglingLink(DeltaQuery deleter, DeltaQuery inserter, boolean local_remote) {
        Iterator it = deleter.getDelta().getContent().iterator();
        while (it.hasNext()) {
            Delete delete;
            Conflict conf;
            Object o = it.next();
            if (!(o instanceof Delete) || (conf = ConflictDetectionHelper.detectDanglingLink(inserter, delete = (Delete)o)) == null) continue;
            this.conflicts.add(conf);
        }
    }

    void detectMultiplicityViolation() {
        Create c;
        NodeLevelSubDelta sub;
        HashSet deletedNodeIDs = new HashSet(this.localQuery.getDeletedNodeIDs());
        deletedNodeIDs.addAll(this.remoteQuery.getDeletes());
        Object it = this.baseVariant.getAllContents();
        while (it.hasNext()) {
            EObject o = (EObject)it.next();
            String id = this.baseVariant.getURIFragment(o);
            logger.debug((Object)("check multiplicity of " + SimpleModelLabelProvider.getObjectTypeAndName(o)));
            if (deletedNodeIDs.contains(id)) continue;
            this.detectMultiplicityViolation(id, o, o.eClass());
        }
        it = this.localQuery.getDelta().getContent().iterator();
        while (it.hasNext()) {
            sub = (NodeLevelSubDelta)it.next();
            if (!(sub instanceof Create)) continue;
            c = (Create)sub;
            logger.debug((Object)("check multiplicity of new node (created at local) " + sub.getId()));
            this.detectMultiplicityViolation(sub.getId(), null, c.getType());
        }
        it = this.remoteQuery.getDelta().getContent().iterator();
        while (it.hasNext()) {
            sub = (NodeLevelSubDelta)it.next();
            if (!(sub instanceof Create)) continue;
            c = (Create)sub;
            logger.debug((Object)("check multiplicity of new node (created at remote) " + sub.getId()));
            this.detectMultiplicityViolation(sub.getId(), null, c.getType());
        }
    }

    void detectMultiplicityViolation(String id, EObject baseObject, EClass clazz) {
        Iterator it = clazz.getEAllReferences().iterator();
        while (it.hasNext()) {
            EReference r = (EReference)it.next();
            if (r.isDerived() || r.isTransient() || !r.isChangeable() || !ConflictDetectionHelper.needMultiplicityCheck(r)) {
                logger.debug((Object)("skip " + r.getName()));
                continue;
            }
            Conflict conf = ConflictDetectionHelper.checkMultiplicity(id, baseObject, r, this.localQuery, this.remoteQuery);
            if (conf == null) continue;
            this.conflicts.add(conf);
        }
    }
}

