/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.merge.util;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.BasicConflictHandler;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.DeltaQuery;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.Conflict;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.Create;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.Delete;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.Delta;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.InsertLink;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.Merge;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.ModifyLink;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.ModifyLinkElement;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.ModifyPrimitive;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.NodeLevelSubDelta;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.SubDelta;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.util.ModelLabelProvider;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.util.SimpleModelLabelProvider;

public class MergeModel2Text {
    ModelLabelProvider modelLabelProvider = new SimpleModelLabelProvider();

    public String getText(EObject o) {
        try {
            Object d;
            if (o == null) {
                return null;
            }
            if (o instanceof Merge) {
                Merge m = (Merge)o;
                this.modelLabelProvider.setMergeModel(m);
            }
            if (o instanceof NodeLevelSubDelta) {
                d = (NodeLevelSubDelta)o;
                boolean isLocalModel = DeltaQuery.isLocalSubDelta(d);
                String modelElementLabel = this.modelLabelProvider.getText(d.getId(), isLocalModel);
                if (o instanceof Create) {
                    return "create " + modelElementLabel;
                }
                if (o instanceof Delete) {
                    return "delete " + modelElementLabel;
                }
                return "modify " + modelElementLabel;
            }
            if (o instanceof ModifyPrimitive) {
                ModifyPrimitive mp = (ModifyPrimitive)o;
                return "set " + this.showFeature(mp.getProperty()) + "=" + mp.getValue();
            }
            if (o instanceof ModifyLink) {
                ModifyLink ml = (ModifyLink)o;
                return "ModifyLink " + this.showFeature(ml.getProperty());
            }
            if (o instanceof ModifyLinkElement) {
                ModifyLinkElement elem = (ModifyLinkElement)o;
                boolean isLocalModel = DeltaQuery.isLocalSubDelta(elem);
                String list = this.showReferenceList((List)elem.getRef(), isLocalModel);
                EReference r = DeltaQuery.getProperty(elem);
                if (r != null && r.isOrdered() && elem instanceof InsertLink) {
                    InsertLink il = (InsertLink)elem;
                    String position = il.getPosAfter() == null ? "@begin" : "after " + this.modelLabelProvider.getText(il.getPosAfter(), isLocalModel);
                    return "InsertLink " + list + " " + position;
                }
                return String.valueOf(elem.eClass().getName()) + " " + list;
            }
            if (o instanceof Conflict) {
                Conflict conf = (Conflict)o;
                return this.showConflict(conf);
            }
            if (o instanceof Delta) {
                d = (Delta)o;
                EStructuralFeature f = d.eContainingFeature();
                if (f != null) {
                    return f.getName();
                }
                return "Delta";
            }
            return SimpleModelLabelProvider.getObjectTypeAndName(o);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String showConflict(Conflict conf) {
        StringBuffer buf = new StringBuffer();
        buf.append(String.valueOf(conf.getType()) + " ");
        if (!conf.getLocal().isEmpty() && BasicConflictHandler.isAllCanceled((List)conf.getLocal())) {
            buf.append("(canceled) ");
        }
        buf.append(this.showSubDeltaList((List)conf.getLocal()));
        buf.append(" | ");
        if (!conf.getRemote().isEmpty() && BasicConflictHandler.isAllCanceled((List)conf.getRemote())) {
            buf.append("(canceled) ");
        }
        buf.append(this.showSubDeltaList((List)conf.getRemote()));
        return buf.toString();
    }

    public String showFeature(EStructuralFeature f) {
        if (f == null) {
            return "null";
        }
        return f.getName();
    }

    public String showSubDeltaList(List l) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < l.size()) {
            SubDelta d = (SubDelta)l.get(i);
            if (i == 0) {
                buf.append(this.getText(d));
            } else {
                buf.append(" ," + this.getText(d));
            }
            ++i;
        }
        return buf.toString();
    }

    public String showReferenceList(List ids, boolean isLocalModel) {
        StringBuffer buf = new StringBuffer();
        buf.append("{");
        int i = 0;
        while (i < ids.size()) {
            String id = (String)ids.get(i);
            String rep = this.modelLabelProvider.getText(id, isLocalModel);
            if (i == 0) {
                buf.append(rep);
            } else {
                buf.append(" ," + rep);
            }
            ++i;
        }
        buf.append("}");
        return buf.toString();
    }
}

