/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.ModelUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.QualifiedServiceName;
import org.eclipse.mddi.modelbus.description.abstract_.AbstractFactory;
import org.eclipse.mddi.modelbus.description.abstract_.DirectionKind;
import org.eclipse.mddi.modelbus.description.abstract_.Error;
import org.eclipse.mddi.modelbus.description.abstract_.ModelingService;
import org.eclipse.mddi.modelbus.description.abstract_.Parameter;
import org.eclipse.mddi.modelbus.description.abstract_.impl.AbstractPackageImpl;
import org.eclipse.mddi.modelbus.description.concrete.ConcreteFactory;
import org.eclipse.mddi.modelbus.description.concrete.Property;
import org.eclipse.mddi.modelbus.description.concrete.Tool;
import org.eclipse.mddi.modelbus.description.concrete.impl.ConcretePackageImpl;

public class DescriptionUtil {
    public static final String IS_SESSION_ENABLED = "IsSessionEnabled";
    public static final AbstractFactory abstractFactory = AbstractPackageImpl.init().getAbstractFactory();
    public static final ConcreteFactory concreteFactory = ConcretePackageImpl.init().getConcreteFactory();

    public static ModelingService getServiceDescription(String serviceName, Tool t) {
        QualifiedServiceName qname = QualifiedServiceName.getQualifiedServiceName(serviceName);
        Iterator it = t.getInterface().getService().iterator();
        while (it.hasNext()) {
            ModelingService s = (ModelingService)it.next();
            if (!qname.serviceName.equals(s.getName())) continue;
            return s;
        }
        return null;
    }

    public static boolean isToolEqual(Tool t1, Tool t2) {
        if (t1.getName().equals(t2.getName()) && t1.getInterface().getName().equals(t2.getInterface().getName())) {
            Iterator it = t1.getInterface().getService().iterator();
            while (it.hasNext()) {
                ModelingService testService = (ModelingService)it.next();
                ModelingService matchingService = DescriptionUtil.getServiceDescription(testService.getName(), t2);
                if (matchingService != null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static List get_in_inout_Parameters(ModelingService ms) {
        DirectionKind[] dk = new DirectionKind[]{DirectionKind.IN_LITERAL, DirectionKind.INOUT_LITERAL};
        return DescriptionUtil.getParameters(ms, dk);
    }

    public static List get_out_inout_Parameters(ModelingService ms) {
        DirectionKind[] dk = new DirectionKind[]{DirectionKind.OUT_LITERAL, DirectionKind.RETURN_LITERAL, DirectionKind.INOUT_LITERAL};
        return DescriptionUtil.getParameters(ms, dk);
    }

    public static List getInParameters(ModelingService ms) {
        DirectionKind[] dk = new DirectionKind[]{DirectionKind.IN_LITERAL};
        return DescriptionUtil.getParameters(ms, dk);
    }

    public static List getOutParameters(ModelingService ms) {
        DirectionKind[] dk = new DirectionKind[]{DirectionKind.OUT_LITERAL};
        return DescriptionUtil.getParameters(ms, dk);
    }

    public static List getInoutParameters(ModelingService ms) {
        DirectionKind[] dk = new DirectionKind[]{DirectionKind.INOUT_LITERAL};
        return DescriptionUtil.getParameters(ms, dk);
    }

    public static List getParameters(ModelingService ms, DirectionKind[] dk) {
        Vector<Parameter> result = new Vector<Parameter>();
        Iterator it = ms.getParameter().iterator();
        while (it.hasNext()) {
            Parameter p = (Parameter)it.next();
            int i = 0;
            while (i < dk.length) {
                if (p.getDirection().equals(dk[i])) {
                    result.add(p);
                }
                ++i;
            }
        }
        return result;
    }

    public static Error getError(ModelingService ms, String errorName) {
        EList errors = ms.getServiceError();
        Iterator it = errors.iterator();
        while (it.hasNext()) {
            Error error = (Error)it.next();
            if (!error.getName().equals(errorName)) continue;
            return error;
        }
        return null;
    }

    public static Parameter getParameter(ModelingService ms, String paramName) {
        Iterator it = ms.getParameter().iterator();
        while (it.hasNext()) {
            Parameter p = (Parameter)it.next();
            if (!paramName.equals(p.getName())) continue;
            return p;
        }
        return null;
    }

    public static String getParameterNameList(Parameter[] params) {
        String result = null;
        int i = 0;
        while (i < params.length) {
            Parameter p = params[i];
            result = result == null ? p.getName() : String.valueOf(result) + ", " + p.getName();
            ++i;
        }
        return result;
    }

    public static String getProperty(Tool t, String propertyName) {
        Iterator it = t.getProperty().iterator();
        while (it.hasNext()) {
            Property p = (Property)it.next();
            String proName = p.getName();
            if (proName == null) {
                return null;
            }
            if (!proName.equalsIgnoreCase(propertyName)) continue;
            return p.getValue();
        }
        return null;
    }

    public static Property getPropertyObject(Tool t, String propertyName) {
        Iterator it = t.getProperty().iterator();
        while (it.hasNext()) {
            Property p = (Property)it.next();
            if (!p.getName().equalsIgnoreCase(propertyName)) continue;
            return p;
        }
        return null;
    }

    public static boolean getIsSessionEnabled(Tool t) {
        String pro = DescriptionUtil.getProperty(t, IS_SESSION_ENABLED);
        if (pro == null) {
            return false;
        }
        return pro.startsWith("true");
    }

    public static void importAllMetamodels(Tool t, Collection ignoredUriPrefixSet) {
        Resource r = t.eResource();
        HashSet<Resource> s = new HashSet<Resource>();
        s.add(r);
        ModelUtil.addCrossReferencedResources(s, ignoredUriPrefixSet);
        Iterator it = s.iterator();
        while (it.hasNext()) {
            Resource r2 = (Resource)it.next();
            if (r2 == r) continue;
            r.getContents().addAll((Collection)r2.getContents());
        }
    }
}

