/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.emf_xmi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.GlobalResourceRegistry;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.ModelBusResourceSet;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.ModelUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.DeserializedModel;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.ModelElementReference;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.ModelSerializer;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.SerializedXmiDocument;
import org.eclipse.mddi.modelbus.description.abstract_.ModelType;
import org.eclipse.mddi.modelbus.description.abstract_.Parameter;

public class DefaultModelSerializer
implements ModelSerializer {
    private static Logger logger;
    protected boolean skipCrossReferences = false;
    protected Collection ignoredUriPrefixSet = new Vector(GlobalResourceRegistry.GLOBAL_URI_PREFIX_SET);
    public boolean canChangeURI = true;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.emf_xmi.DefaultModelSerializer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public boolean isSkipCrossReferences() {
        return this.skipCrossReferences;
    }

    public void setSkipCrossReferences(boolean skipCrossReferences) {
        this.skipCrossReferences = skipCrossReferences;
    }

    public Collection getIgnoredUriPrefixSet() {
        return this.ignoredUriPrefixSet;
    }

    public SerializedXmiDocument[] serialize(Parameter[] params, Object[] values) {
        Collection allModelElements = this.getScope(params, values);
        Resource[] res = ModelUtil.getResourcesFromObjects(allModelElements, this.skipCrossReferences, this.ignoredUriPrefixSet);
        return this.serializeResources(res);
    }

    public Collection getScope(Parameter[] params, Object[] values) {
        Vector allModelElements = new Vector();
        int i = 0;
        while (i < params.length) {
            if (params[i].getType() instanceof ModelType) {
                if (params[i].getUpper() == 1) {
                    allModelElements.addAll((Collection)values[i]);
                } else {
                    Collection[] modelArray = (Collection[])values[i];
                    int j = 0;
                    while (j < modelArray.length) {
                        allModelElements.addAll(modelArray[j]);
                        ++j;
                    }
                }
            }
            ++i;
        }
        return allModelElements;
    }

    public SerializedXmiDocument[] serializeResources(Resource[] res) {
        HashSet<String> uris = new HashSet<String>();
        Vector<SerializedXmiDocument> docVector = new Vector<SerializedXmiDocument>();
        int i = 0;
        while (i < res.length) {
            try {
                SerializedXmiDocument doc = new SerializedXmiDocument();
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                res[i].save((OutputStream)bout, null);
                doc.setXmi(bout.toString());
                String uri = res[i].getURI().toString();
                while (this.canChangeURI && uris.contains(uri)) {
                    uri = "_" + uri;
                    res[i].setURI(URI.createURI((String)("_" + uri)));
                    logger.error((Object)("Redundant URI. Changed to " + uri));
                }
                doc.setUri(uri);
                uris.add(uri);
                docVector.add(doc);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            ++i;
        }
        return docVector.toArray(new SerializedXmiDocument[docVector.size()]);
    }

    public DeserializedModel[] deserialize(SerializedXmiDocument[] documents) {
        DeserializedModel[] result = new DeserializedModel[documents.length];
        ModelBusResourceSet rs = new ModelBusResourceSet();
        int i = 0;
        while (i < documents.length) {
            result[i] = new DeserializedModel();
            result[i].setUri(documents[i].getUri());
            try {
                ByteArrayInputStream bin = new ByteArrayInputStream(documents[i].getXmi().getBytes());
                Resource r = rs.createResource(URI.createURI((String)documents[i].getUri()));
                r.load((InputStream)bin, null);
                result[i].setValue(r);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            ++i;
        }
        return result;
    }

    public ModelElementReference[] getReferences(SerializedXmiDocument[] documents, Parameter p, Object o) {
        Collection c = (Collection)o;
        Vector<ModelElementReference> v = new Vector<ModelElementReference>();
        Iterator it = c.iterator();
        while (it.hasNext()) {
            EObject eo = (EObject)it.next();
            Resource r = eo.eResource();
            ModelElementReference ref = new ModelElementReference();
            ref.setUri(r.getURI().toString());
            ref.setRef(r.getURIFragment(eo));
            v.add(ref);
        }
        return v.toArray(new ModelElementReference[v.size()]);
    }

    public Object dereference(DeserializedModel[] data, Parameter p, ModelElementReference[] refs) {
        Vector<EObject> v = new Vector<EObject>();
        int i = 0;
        while (i < refs.length) {
            String uri = refs[i].getUri();
            String ref = refs[i].getRef();
            boolean foundResource = false;
            int j = 0;
            while (j < data.length) {
                if (data[j].getUri().equals(uri)) {
                    foundResource = true;
                    Resource r = (Resource)data[j].getValue();
                    try {
                        EObject eo = null;
                        eo = r.getEObject(ref);
                        if (eo != null) {
                            v.add(eo);
                            break;
                        }
                        logger.error((Object)("Fragment Not Found " + uri + ", " + ref));
                    }
                    catch (Exception e) {
                        logger.error((Object)e);
                    }
                    v.removeAll((Collection<?>)r.getContents());
                    v.addAll((Collection<EObject>)r.getContents());
                }
                ++j;
            }
            if (!foundResource) {
                logger.error((Object)("Resource Not Found " + uri));
            }
            ++i;
        }
        return v;
    }

    public boolean canChangeURI() {
        return this.canChangeURI;
    }

    public void setCanChangeURI(boolean canChangeURI) {
        this.canChangeURI = canChangeURI;
    }
}

