/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.transport.client.local;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.log4j.Logger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.axisasync.NoAsyncConnectionFoundException;
import org.eclipse.mddi.modelbus.adapter.infrastructure.axisasync.PollObject;
import org.eclipse.mddi.modelbus.adapter.infrastructure.axisasync.ResultNotReadyException;
import org.eclipse.mddi.modelbus.adapter.infrastructure.axisasync.ThreadPoolQueue;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.client.ws.DefaultSessionWsInvocationSender;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.client.ws.DefaultWsInvocationSender;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.marshal.ws.SoapUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.server.ws.EndPointManagerImpl;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.server.ws.ProviderEndPoint;
import org.eclipse.mddi.modelbus.adapter.user.ModelingServiceError;
import org.eclipse.mddi.modelbus.adapter.user.consumer.ModelBusCommunicationException;
import org.eclipse.mddi.modelbus.adapter.user.consumer.ModelTypeMismatchException;
import org.eclipse.mddi.modelbus.adapter.user.consumer.NoToolAvailableException;
import org.eclipse.mddi.modelbus.adapter.user.consumer.ServiceUnknownException;
import org.eclipse.mddi.modelbus.description.abstract_.ModelingService;

public class LocalSessionInvocationSender
extends DefaultSessionWsInvocationSender {
    private static Logger logger;
    private Map pollObjectMap = new HashMap();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.mddi.modelbus.adapter.infrastructure.transport.client.local.LocalSessionInvocationSender");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public LocalSessionInvocationSender(Properties prop) {
        super(prop);
    }

    public void makeConnection() throws SOAPException {
        logger.debug((Object)"Local Call");
        String relativePath = ProviderEndPoint.getRelativePath(this.getToolDescription().getName());
        ProviderEndPoint ep = (ProviderEndPoint)EndPointManagerImpl.getInstance().getEndPoint(relativePath);
        logger.debug((Object)("Call with Message: " + this.requestMsg.getSOAPBody().toString()));
        this.responseMsg = SoapUtil.messageFactory.createMessage();
        ep.execute(relativePath, this.requestMsg.getSOAPPart().getEnvelope(), this.responseMsg.getSOAPPart().getEnvelope());
        logger.debug((Object)("Response Message: " + this.responseMsg.getSOAPBody().toString()));
    }

    public void makeAsyncConnection() throws SOAPException {
        logger.debug((Object)"Asynchronous Local Call");
        String relativePath = ProviderEndPoint.getRelativePath(this.getToolDescription().getName());
        ProviderEndPoint ep = (ProviderEndPoint)EndPointManagerImpl.getInstance().getEndPoint(relativePath);
        logger.debug((Object)("Call with Message: " + this.requestMsg.getSOAPBody().toString()));
        PollObject po = new PollObject();
        this.connectionId = String.valueOf(po.hashCode());
        this.pollObjectMap.put(this.connectionId, po);
        LocalSessionInvocationSender.runLocalTask(this.requestMsg, this.responseMsg, po, relativePath, ep, DefaultWsInvocationSender.poolQueue);
        DefaultWsInvocationSender.connexionId2modelingService.put(this.connectionId, this.ms);
        logger.debug((Object)("Response Message: " + this.responseMsg.getSOAPBody().toString()));
    }

    public void closeAsyncConnection(String connectionId) throws SOAPException, NoAsyncConnectionFoundException {
        DefaultWsInvocationSender.connexionId2modelingService.remove(connectionId);
    }

    public boolean isResultReady(String connectionId) throws ServiceUnknownException, NoToolAvailableException, ModelTypeMismatchException, ModelBusCommunicationException, NoAsyncConnectionFoundException, ModelingServiceError {
        PollObject po = (PollObject)this.pollObjectMap.get(connectionId);
        return po.isResultReady();
    }

    public Object[] getResult(String connectionId) throws ResultNotReadyException, NoAsyncConnectionFoundException, ServiceUnknownException, NoToolAvailableException, ModelTypeMismatchException, ModelBusCommunicationException, ModelingServiceError {
        PollObject po;
        try {
            po = (PollObject)this.pollObjectMap.get(connectionId);
        }
        catch (ClassCastException classCastException) {
            throw new NoAsyncConnectionFoundException("asynchronous local call - poll object not found in local pollObjectMap");
        }
        if (po == null) {
            throw new NoAsyncConnectionFoundException("asynchronous local call - poll object not found in local pollObjectMap");
        }
        try {
            this.responseMsg = (SOAPMessage)po.getResult();
            ModelingService ms = (ModelingService)DefaultWsInvocationSender.connexionId2modelingService.get(connectionId);
            if (ms == null) {
                throw new Exception("ModelingService not avaible");
            }
            this.readResponseMessage();
            this.closeAsyncConnection(connectionId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.unmarshalledOutputs;
    }

    private static void runLocalTask(SOAPMessage reqMsg, SOAPMessage resMsg, PollObject po, String relativePath, ProviderEndPoint ep, ThreadPoolQueue pool) {
        LocalTask task = new LocalTask(reqMsg, resMsg, po, relativePath, ep);
        pool.execute(task);
    }

    private static class LocalTask
    implements Runnable {
        private SOAPMessage reqMsg;
        private SOAPMessage resMsg;
        private PollObject po;
        private String relativePath;
        private ProviderEndPoint providerEndPoint;

        public LocalTask(SOAPMessage reqMsg, SOAPMessage resMsg, PollObject po, String relativePath, ProviderEndPoint providerEndPoint) {
            this.reqMsg = reqMsg;
            this.resMsg = resMsg;
            this.po = po;
            this.relativePath = relativePath;
            this.providerEndPoint = providerEndPoint;
        }

        public void run() {
            try {
                this.providerEndPoint.execute(this.relativePath, this.reqMsg.getSOAPPart().getEnvelope(), this.resMsg.getSOAPPart().getEnvelope());
                this.po.registerResult(this.resMsg);
            }
            catch (SOAPException e) {
                e.printStackTrace();
            }
        }
    }
}

