/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.transport.server.ws;

import java.util.List;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import org.apache.log4j.Logger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.LoggerConfigurator;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.DescriptionUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.marshal.ws.DefaultMarshaler;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.marshal.ws.SoapUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.server.ws.WsInvocationReceiver;
import org.eclipse.mddi.modelbus.adapter.user.AdapterStub;
import org.eclipse.mddi.modelbus.adapter.user.InvalidSession;
import org.eclipse.mddi.modelbus.adapter.user.ModelingServiceError;
import org.eclipse.mddi.modelbus.adapter.user.SessionNeeded;
import org.eclipse.mddi.modelbus.adapter.user.provider.GenericProvider;
import org.eclipse.mddi.modelbus.description.abstract_.ModelingService;
import org.eclipse.mddi.modelbus.description.abstract_.Parameter;

public class DefaultWsInvocationReceiver
extends WsInvocationReceiver {
    AdapterStub adapter;
    SOAPEnvelope reqMsg;
    SOAPEnvelope resMsg;
    ModelingService ms;
    Object[] unmarshalledInputs;
    Object[] unmarshalledOutputs;
    private static Logger logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.mddi.modelbus.adapter.infrastructure.transport.server.ws.DefaultWsInvocationReceiver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public DefaultWsInvocationReceiver(AdapterStub adapter) {
        LoggerConfigurator.configure();
        this.adapter = adapter;
        this.setMarshaler(new DefaultMarshaler(adapter.getProperties()));
    }

    public void process(SOAPEnvelope reqMsg, SOAPEnvelope resMsg) throws SOAPException {
        this.reqMsg = reqMsg;
        this.resMsg = resMsg;
        try {
            this.readRequest();
            this.performService();
            this.createResponse();
        }
        catch (Exception e) {
            this.createSoapFault(resMsg, e);
            logger.debug((Object)resMsg, (Throwable)e);
        }
    }

    public void readRequest() throws Exception {
        SOAPBody requestbody = this.reqMsg.getBody();
        SOAPElement reqTopElem = SoapUtil.getFirstChild((SOAPElement)requestbody);
        if (reqTopElem == null) {
            logger.error((Object)"SERVER: received empty request");
            logger.debug((Object)this.reqMsg);
            throw new SOAPException("Empty SOAP request");
        }
        String serviceName = reqTopElem.getLocalName();
        this.ms = DescriptionUtil.getServiceDescription(serviceName, this.adapter.getToolDescription());
        if (this.ms == null) {
            throw new SOAPException("Service unknown - " + serviceName);
        }
        List inputParams = DescriptionUtil.get_in_inout_Parameters(this.ms);
        Parameter[] params = new Parameter[inputParams.size()];
        int i = 0;
        while (i < inputParams.size()) {
            params[i] = (Parameter)inputParams.get(i);
            ++i;
        }
        this.unmarshalledInputs = this.marshaler.unmarshal(params, reqTopElem);
    }

    public void performService() throws SessionNeeded, ModelingServiceError, InvalidSession {
        GenericProvider si = this.adapter.getToolStub().getProvider();
        String serviceName = this.ms.getName();
        this.unmarshalledOutputs = si.execute(serviceName, this.unmarshalledInputs);
    }

    public void createResponse() throws Exception {
        SOAPBody responsebody = this.resMsg.getBody();
        DefaultMarshaler.setNamespaces(responsebody);
        SOAPElement resTopElem = responsebody.addChildElement(String.valueOf(this.ms.getName()) + "Response", "modelbus");
        List outputParams = DescriptionUtil.get_out_inout_Parameters(this.ms);
        Parameter[] params = outputParams.toArray(new Parameter[outputParams.size()]);
        this.marshaler.marshal(params, this.unmarshalledOutputs, resTopElem);
    }

    public void createSoapFault(SOAPEnvelope resMsg, Exception cause) throws SOAPException {
        SOAPBody responsebody = resMsg.getBody();
        DefaultMarshaler.setNamespaces(responsebody);
        SOAPFault f = responsebody.addFault();
        if (cause instanceof ModelingServiceError) {
            ModelingServiceError err = (ModelingServiceError)cause;
            this.marshaler.marshalModelingServiceError(err, f);
        } else {
            f.setFaultString(cause.getClass() + ":" + cause.getMessage());
            logger.error((Object)"Error", (Throwable)cause);
        }
    }

    public static void createSimpleSoapFault(SOAPEnvelope resMsg, Exception cause) throws SOAPException {
        SOAPBody responsebody = resMsg.getBody();
        DefaultMarshaler.setNamespaces(responsebody);
        SOAPFault f = responsebody.addFault();
        f.setFaultString(cause.getClass() + ":" + cause.getMessage());
        logger.error((Object)"Error", (Throwable)cause);
    }

    public static void createSoapFault(SOAPEnvelope resMsg, String errMessage) throws SOAPException {
        SOAPBody responsebody = resMsg.getBody();
        DefaultMarshaler.setNamespaces(responsebody);
        SOAPFault f = responsebody.addFault();
        f.setFaultCode("modelbus:ServerError");
        f.setFaultString(errMessage);
        logger.error((Object)("modelbus:ServerError. " + errMessage));
    }
}

