/*
 * Created on 19 juin 2006
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.axisasync;


import javax.xml.soap.SOAPException;




/**
 * This class is responsible for creating new asynchronous connections.
 * @author Nicolas Garandeau (lip6)
 *
 */
public abstract class SOAPAsyncConnectionFactory {


	
	  public SOAPAsyncConnectionFactory() {}
	

	   /**
	    * Create a new instance of SOAPAsyncConnectionFactory
	    */
	  public static SOAPAsyncConnectionFactory newInstance()
	  throws SOAPException, UnsupportedOperationException {
	  	
	  	try {
	  	
	  		return new SOAPAsyncConnectionFactoryImpl();
	  	} catch (Exception exception) {
	  		throw new SOAPException("Unable to create SOAP Async connection factory: "
	  				+ exception.getMessage());
	  	}
	  }
	  
	  
	  
	  
	    /**
	     * Create a new <CODE>SOAPAsyncConnection</CODE>.
	     * @return the new <CODE>SOAPAsyncConnection</CODE> object.
	     * @throws  SOAPException if there was an exception
	     *     creating the <CODE>SOAPAsyncConnection</CODE> object.
	     */
	  public abstract SOAPAsyncConnection createAsyncConnection() throws SOAPException;
	
	  



}
