/*
 * $RCSfile: ConflictHandler.java,v $
 * $Date: 2006/05/16 11:43:11 $
 * $Revision: 1.1 $
 * $Author: xblanc $
 */
 
/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */
 
/*
 * ConflictHandler.java Add description 
 * 
 * @author Prawee Sriplakich
 * @version $Revision: 1.1 $ $Date: 2006/05/16 11:43:11 $
 * @see Add references
 *
 * TODO Add description
 * TODO Add references
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.merge;

import java.util.Collection;

import org.eclipse.emf.ecore.resource.Resource;



/**
 * 
 * This is an interface of any conflict handler implementations.
 * It offers an operation for producing a unified delta (d3) 
 * from local delta and remote delta.
 * <br>
 * The d3 must be coherent : 
 * The d3 must contain no sub-deltas that are conflicting with each other. 
 * More precisely:
 * <br><br>
 * - It must contain no sub-deltas that cancel the effects of one another. 
 * (lost update)<br>
 * - It must produce valid multiplicity <br>
 * - It must produce no dangling links. <br>
 * 
 * 
 * @param mergeData
 * 
 *
 */
public interface ConflictHandler {
    

    public void start(MergeData mergeData);
    
    public MergeData getMergeData();
    
    /**
     * 
     * check if there are any more conflicts to be resolved
     * 
     * @return the conflicts not yet resolved
     */
    public Collection testFinish();    
    
    public boolean finished();
    
    public Resource getResult();
    
    
    /*
     * Note.
     * Consider dependency between subdeltas.
     *  - [ModifyProp of O1] depends on [Create O1]
     *  - ModifyLink that create links to O1  depends on [Create O1]
     *  - [Delete O1] depends on RemoveLink operations that destroy all references to O1.
     * 
     * 
     */

}
