/*
 * $RCSfile: DeltaCalculation.java,v $
 * $Date: 2006/05/17 12:12:12 $
 * $Revision: 1.2 $
 * $Author: xblanc $
 */

/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

/*
 * ModelProcesser.java Add description 
 * 
 * @author Prawee Sriplakich
 * @version $Revision: 1.2 $ $Date: 2006/05/17 12:12:12 $
 * @see Add references
 *
 * TODO Add description
 * TODO Add references
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.merge;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.Create;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.Delete;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.Delta;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.InsertLink;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.Merge;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.MergeFactory;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.MergePackage;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.ModifyExisting;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.ModifyLink;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.ModifyPrimitive;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.ModifyProp;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.RemoveLink;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.util.Diff;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.util.Difference;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.impl.MergePackageImpl;

public class DeltaCalculation {

    static Logger logger = Logger.getLogger("DeltaCalculation");

    static MergeFactory fac;
    static {
        try {
            MergePackageImpl.init();
            fac = (MergeFactory) MergePackage.eINSTANCE.getEFactoryInstance();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Delta diff(Resource base, Resource variant) {
        Internal internal = new Internal();
        return internal.diff(base, variant);
    }

    public static Merge diff3(Resource base, Resource localVariant,
            Resource remoteVariant) {
        Merge m = fac.createMerge();
        m.setResourceURL(localVariant.getURI().toString());

        Delta localDelta = diff(base, localVariant);
        m.setLocalDelta(localDelta);
        Delta remoteDelta = diff(base, remoteVariant);
        m.setRemoteDelta(remoteDelta);
        return m;
    }

    public static class Internal {

        Collection newIds;

        Collection deletedIds;

        Collection commonIds;

        public Delta diff(Resource base, Resource variant) {
            Delta d = fac.createDelta();
            // find new model elements;
            newIds = MergeHelper.getExtraElements(base, variant);
            for (Iterator it = newIds.iterator(); it.hasNext();) {
                String id = (String) it.next();
                EObject newNode = variant.getEObject(id);
                Create create = fac.createCreate();
                EClass clazz = newNode.eClass();
                create.setType(clazz);
                create.setId(id);
                d.getContent().add(create);
                Collection features = clazz.getEAllStructuralFeatures();
                for (Iterator it2 = features.iterator(); it2.hasNext();) {
                    EStructuralFeature f = (EStructuralFeature) it2.next();
                    ModifyProp modprop = calculatePropertySetting(f, newNode);
                    if (modprop != null) {
                        create.getContent().add(modprop);
                    }
                }
            }
            // find delete model elements;
            deletedIds = MergeHelper.getExtraElements(variant, base);
            for (Iterator it = deletedIds.iterator(); it.hasNext();) {
                String id = (String) it.next();
                fac.createDelete();
                Delete delete = fac.createDelete();
                delete.setId(id);
                d.getContent().add(delete);
                // EObject oldNode = base.getEObject(id);
                // for (Iterator it2 =
                // oldNode.eClass().getEAllReferences().iterator();
                // it2.hasNext();) {
                // EReference r = (EReference) it2.next();
                // ModifyLink ml = calculateRemoveLink(r, oldNode);
                // if(ml!=null) {
                // delete.getContent().add(ml);
                // }
                // }
            }
            // find property changes
            commonIds = MergeHelper.getCommonElements(base, variant);
            for (Iterator it = commonIds.iterator(); it.hasNext();) {
                String id = (String) it.next();
                ModifyExisting mod = null;
                EObject oldNode = base.getEObject(id);
                EObject newNode = variant.getEObject(id);
                Collection features = oldNode.eClass()
                        .getEAllStructuralFeatures();
                for (Iterator it2 = features.iterator(); it2.hasNext();) {
                    EStructuralFeature f = (EStructuralFeature) it2.next();
                    ModifyProp modprop = calculatePropertyChange(f, oldNode,
                            newNode);
                    if (modprop != null) {
                        if (mod == null) {
                            mod = fac.createModifyExisting();
                            mod.setId(id);
                            d.getContent().add(mod);
                        }
                        mod.getContent().add(modprop);
                    }
                }
            }
            return d;
        }

        // public ModifyLink calculateRemoveLink(EReference r, EObject oldNode)
        // {
        // if(MergeHelper.needsComparison(r)) {
        // Object v = oldNode.eGet(r);
        // if((v instanceof Collection) &&!((Collection)v).isEmpty()) {
        // ModifyLink ml = fac.createModifyLink();
        // RemoveLink rl = fac.createRemoveLink();
        // List ids = MergeHelper.getIDList((Collection)v);
        // rl.getRef().addAll(ids);
        // ml.setRemove(rl);
        // ml.setProperty(r);
        // return ml;
        // } if(v instanceof EObject) {
        // ModifyLink ml = fac.createModifyLink();
        // RemoveLink rl = fac.createRemoveLink();
        // String removedID = (String)
        // oldNode.eResource().getURIFragment((EObject)v);
        // rl.getRef().add(removedID);
        // ml.setRemove(rl);
        // ml.setProperty(r);
        // return ml;
        // }
        // }
        // return null;
        // }

        public ModifyProp calculatePropertySetting(EStructuralFeature f,
                EObject newNode) {

            if (!MergeHelper.needsComparison(f)) {
                return null;
            }
            Object v = newNode.eGet(f);
            if (v == null
                    || ((v instanceof Collection) && ((Collection) v).isEmpty())) {
                return null;
            }
            if (f instanceof EAttribute) {
                EAttribute a = (EAttribute) f;
                ModifyPrimitive modprim = fac.createModifyPrimitive();
                modprim.setProperty(f);
                String s = MergeHelper.serializeValue(a.getEAttributeType(), v);
                modprim.setValue(s);
                return modprim;
            } else {
                ModifyLink modl = fac.createModifyLink();
                modl.setProperty(f);
                InsertLink insert = fac.createInsertLink();
                modl.getInsert().add(insert);
                if (v instanceof Collection) {
                    Collection ids = MergeHelper.getIDList((Collection) v);
                    insert.getRef().addAll(ids);
                } else if (v != null) {
                    String id = MergeHelper.getURIFragment((EObject) v);
                    insert.getRef().add(id);
                }
                return modl;
            }

        }

        public ModifyProp calculatePropertyChange(EStructuralFeature f,
                EObject oldNode, EObject newNode) {
            if (!MergeHelper.needsComparison(f)) {
                // logger.debug("skip " + f.getEContainingClass().getName()
                // +"."+ f.getName());
                return null;
            }
            Object oldValue = oldNode.eGet(f);
            Object newValue = newNode.eGet(f);
            if (f instanceof EAttribute) {
                EAttribute a = (EAttribute) f;
                if (MergeHelper.areDiffrent(oldValue, newValue)) {
                    ModifyPrimitive mod = fac.createModifyPrimitive();
                    mod.setProperty(f);
                    String s = MergeHelper.serializeValue(
                            a.getEAttributeType(), newValue);
                    mod.setValue(s);
                    return mod;
                }
            } else {
                return calculateLinkChange((EReference) f, oldValue, newValue);
            }
            return null;
        }

        public ModifyLink calculateLinkChange(EReference r, Object oldValue,
                Object newValue) {
            if (!MergeHelper.doesLinkChange(r, oldValue, newValue)) {
                return null;
            }
            // logger.debug("ModifyLink " + r.getName());
            ModifyLink mod = fac.createModifyLink();
            mod.setProperty(r);
            if (r.isMany()) {
                List baseRefValue = MergeHelper.getIDList((Collection) oldValue);
                List variantRefValue = MergeHelper.getIDList((Collection) newValue);
                calculateRemoveLink(mod, baseRefValue, variantRefValue);
                calculateInsertLink(r, mod, baseRefValue, variantRefValue);
            } else {
                if (oldValue != null) {
                    // create remove Link
                    RemoveLink rl = fac.createRemoveLink();
                    mod.setRemove(rl);
                    String id = MergeHelper.getURIFragment((EObject) oldValue);
                    rl.getRef().add(id);
                }
                if (newValue != null) {
                    // create insert link
                    InsertLink il = fac.createInsertLink();
                    mod.getInsert().add(il);
                    String id = MergeHelper.getURIFragment((EObject) newValue);
                    il.getRef().add(id);
                }
            }
            if(mod.getRemove()==null && mod.getInsert().isEmpty()) {
                return null;
            }
            return mod;
        }

        public void calculateRemoveLink(ModifyLink mod, List base, List variant) {
            List removedRef = new Vector(base);
            removedRef.removeAll(variant);
            // The delta does not include the removal of links to deleted elements
            // because it makes redundant delta.
            removedRef.removeAll(deletedIds);
            if (!removedRef.isEmpty()) {
                RemoveLink rl = fac.createRemoveLink();
                rl.getRef().addAll(removedRef);
                mod.setRemove(rl);
            }
        }
        
        
        public void calculateInsertLink(EReference r, ModifyLink mod, List baseRefValue, List variantRefValue) {
            if (r.isOrdered()) {
                List basePropertyValue = new Vector(baseRefValue);
                basePropertyValue.retainAll(variantRefValue);
                calculateOrderredInsertLinks(mod, basePropertyValue, variantRefValue);
            } else {
                Collection addedRef = new HashSet();
                addedRef.addAll(variantRefValue);
                addedRef.removeAll(baseRefValue);
                if (!addedRef.isEmpty()) {
                    InsertLink il = fac.createInsertLink();
                    il.getRef().addAll(addedRef);
                    mod.getInsert().add(il);
                }
            }
        }

        public void calculateOrderredInsertLinks(ModifyLink mod, List base,
                List variant) {
            Diff diff = new Diff(base, variant);
            List diffItems = diff.diff();
            for (Iterator it = diffItems.iterator(); it.hasNext();) {
                Difference item = (Difference) it.next();
                // logger.debug(item);
                if (item.getAddedEnd() != Difference.NONE) {
                    List addedRef = variant.subList(item.getAddedStart(), item
                            .getAddedEnd() + 1);
                    InsertLink il = fac.createInsertLink();
                    il.getRef().addAll(addedRef);
                    int posAfter = item.getDeletedStart() - 1;
                    if (posAfter != -1) {
                        String idAfter = (String) base.get(posAfter);
                        il.setPosAfter(idAfter);
                    }
                    mod.getInsert().add(il);
                }
            }
        }
    } // class Internal

}
