/*
 * $RCSfile: DeltaQuery.java,v $
 * $Date: 2006/05/17 12:12:13 $
 * $Revision: 1.2 $
 * $Author: xblanc $
 */

/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

/*
 * DeltaQuery.java Add description 
 * 
 * @author Prawee Sriplakich
 * @version $Revision: 1.2 $ $Date: 2006/05/17 12:12:13 $
 * @see Add references
 *
 * TODO Add description
 * TODO Add references
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.merge;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.Create;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.Delete;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.Delta;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.InsertLink;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.Merge;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.MergeFactory;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.MergePackage;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.ModifyLink;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.ModifyLinkElement;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.ModifyPrimitive;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.ModifyProp;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.NodeLevelSubDelta;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.SubDelta;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.ModelUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.impl.MergePackageImpl;

public class DeltaQuery {

    static Logger logger = Logger.getLogger("DeltaQuery");

    static MergeFactory fac;
    static {
        try {
            MergePackageImpl.init();
            fac = (MergeFactory) MergePackage.eINSTANCE.getEFactoryInstance();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected Delta delta;

    /**
     * key: id value: NodeLevelSubDelta
     */
    protected Map nodeLevelMap = new Hashtable();

    /**
     * key:id value: collection of InsertLinks instances
     */
    protected Map oppositeInsertLinkMap = new Hashtable();

    /**
     * key: id value: collection of RemoveLink instances
     */
    protected Map oppositeRemoveLinkMap = new Hashtable();

    protected Collection creates = new Vector();

    protected Collection deletes = new Vector();

    public DeltaQuery(Delta d) {
        this.delta = d;
        createNodeLevelSubDeltaMap(d);
        computeOppositeModifyLinks();

    }

    /**
     * 
     * create map with the key as an node ID and the value as a node level
     * subdelta that affact the node corresponding to this ID.
     * 
     * @param d
     * @return
     * 
     */
    protected void createNodeLevelSubDeltaMap(Delta d) {
        for (Iterator it = d.getContent().iterator(); it.hasNext();) {
            NodeLevelSubDelta sub = (NodeLevelSubDelta) it.next();
            nodeLevelMap.put(sub.getId(), sub);
            if (sub instanceof Create) {
                creates.add(sub);
            } else if (sub instanceof Delete) {
                deletes.add(sub);
            }
        }
    }

    private void computeOppositeModifyLinks() {
        for (Iterator it = delta.getContent().iterator(); it.hasNext();) {
            NodeLevelSubDelta o = (NodeLevelSubDelta) it.next();
            for (Iterator it2 = o.getContent().iterator(); it2.hasNext();) {
                Object o2 = it2.next();
                if (o2 instanceof ModifyLink) {
                    ModifyLink ml = (ModifyLink) o2;
                    if (ml.getRemove() != null) {
                        for (Iterator it3 = ml.getRemove().getRef().iterator(); it3
                                .hasNext();) {
                            String id = (String) it3.next();
                            Collection removeLinks = (Collection) oppositeRemoveLinkMap
                                    .get(id);
                            if (removeLinks == null) {
                                removeLinks = new Vector();
                                oppositeRemoveLinkMap.put(id, removeLinks);
                            }
                            logger.debug("put opposite: " + id
                                    + " -> RemoveLink " + ml.getProperty()
                                    + ml.getRemove().getRef());
                            removeLinks.add(ml.getRemove());

                        }
                    }
                    for (Iterator it3 = ml.getInsert().iterator(); it3
                            .hasNext();) {
                        InsertLink il = (InsertLink) it3.next();
                        for (Iterator it4 = il.getRef().iterator(); it4
                                .hasNext();) {
                            String id = (String) it4.next();
                            Collection insertLinks = (Collection) oppositeInsertLinkMap
                                    .get(id);
                            if (insertLinks == null) {
                                insertLinks = new Vector();
                                oppositeInsertLinkMap.put(id, insertLinks);
                            }
                            logger.debug("put opposite: " + id
                                    + " -> InsertLink "
                                    + ml.getProperty().getName() + " "
                                    + il.getRef());
                            insertLinks.add(il);
                        }
                    } // end it3
                }
            } // end it2
        }

    }

    public Delta getDelta() {
        return delta;
    }

    public Collection getAllNodeLevelSubDeltas() {
        return nodeLevelMap.values();
    }

    public Collection getCreates() {
        return creates;
    }

    public Collection getDeletes() {
        return deletes;
    }

    public Collection getCreatedNodeIDs() {
        Collection r = new Vector();
        for (Iterator it = creates.iterator(); it.hasNext();) {
            Create c = (Create) it.next();
            r.add(c.getId());
        }
        return r;
    }

    public Collection getDeletedNodeIDs() {
        Collection r = new Vector();
        for (Iterator it = deletes.iterator(); it.hasNext();) {
            Create c = (Create) it.next();
            r.add(c.getId());
        }
        return r;
    }

    /**
     * 
     * return the Delete instances of the spcified ids
     * 
     * @return
     * 
     * 
     */
    public Collection getDeletes(Collection ids) {
        Collection result = new Vector();
        for (Iterator it = ids.iterator(); it.hasNext();) {
            String id = (String) it.next();
            Object o = nodeLevelMap.get(id);
            if (o instanceof Delete) {
                result.add(o);
            }
        }
        return result;
    }

    /**
     * 
     * change the ID of a created node
     * 
     * @param oldID
     * @param newID
     * 
     * 
     */
    public void changeID(String oldID, String newID) {
        Object o = nodeLevelMap.get(oldID);
        if (!(o instanceof Create)) {
            throw new IllegalArgumentException("invalide ID " + oldID + " -> "
                    + o);
        }
        if (nodeLevelMap.containsKey(newID)) {
            throw new IllegalArgumentException("invalide ID- already exist "
                    + newID + " -> " + nodeLevelMap.get(newID));
        }
        Create c = (Create) o;
        nodeLevelMap.remove(oldID);
        nodeLevelMap.put(newID, c);
        c.setId(newID);
        if (oppositeInsertLinkMap.get(oldID) != null) {
            Collection col = (Collection) oppositeInsertLinkMap.get(oldID);
            oppositeInsertLinkMap.remove(oldID);
            oppositeInsertLinkMap.put(newID, col);
            for (Iterator it = col.iterator(); it.hasNext();) {
                InsertLink link = (InsertLink) it.next();
                int i = link.getRef().indexOf(oldID);
                link.getRef().remove(i);
                link.getRef().add(i, newID);
            }
        }
    }

    public ModifyPrimitive getModifyPrimitive(String ownerID, EAttribute a) {
        return (ModifyPrimitive) getModifyProp(ownerID, a);
    }

    public ModifyLink getModifyLink(String ownerID, EReference r) {
        return (ModifyLink) getModifyProp(ownerID, r);
    }

    public Collection getInsertLinks(String ownerID) {
        Collection c = new Vector();
        NodeLevelSubDelta sub = getNodeLevelSubDelta(ownerID);
        if (sub == null) {
            return c;
        }
        for (Iterator it = sub.getContent().iterator(); it.hasNext();) {
            ModifyProp mp = (ModifyProp) it.next();
            if (mp instanceof ModifyLink) {
                ModifyLink ml = (ModifyLink) mp;
                c.addAll(ml.getInsert());
            }
        }
        return c;
    }

    public Collection getRemoveLinks(String ownerID) {
        Collection c = new Vector();
        NodeLevelSubDelta sub = getNodeLevelSubDelta(ownerID);
        if (sub == null) {
            return c;
        }
        for (Iterator it = sub.getContent().iterator(); it.hasNext();) {
            ModifyProp mp = (ModifyProp) it.next();
            if (mp instanceof ModifyLink) {
                ModifyLink ml = (ModifyLink) mp;
                c.add(ml.getRemove());
            }
        }
        return c;
    }

    public Collection getInsertLinks(String ownerID, EReference r) {
        ModifyLink ml = getModifyLink(ownerID, r);
        if (ml == null)
            return new Vector();
        return ml.getInsert();
    }

    public Collection getRemoveLinks(String ownerID, EReference r) {
        ModifyLink ml = getModifyLink(ownerID, r);
        if (ml == null)
            return new Vector();
        if (ml.getRemove() == null)
            return new Vector();
        Collection result = new Vector();
        result.add(ml.getRemove());
        return result;
    }

    public Collection getOppositeInsertLinks(String ownerID) {
        Collection c = (Collection) oppositeInsertLinkMap.get(ownerID);
        if (c != null) {
            return c;
        }
        return new Vector();
    }

    public Collection getOppositeRemoveLinks(String ownerID) {
        Collection c = (Collection) oppositeRemoveLinkMap.get(ownerID);
        if (c != null) {
            return c;
        }
        return new Vector();
    }

    /**
     * 
     * getOppositeInsertLinks
     * 
     * @param ownerID
     * @param r
     *            the opposite reference that points to the node with ownerID
     * @return
     * 
     * 
     */
    public Collection getOppositeInsertLinks(String ownerID, EReference r) {
        Collection c = getOppositeInsertLinks(ownerID);
        Collection result = new Vector();
        for (Iterator it = c.iterator(); it.hasNext();) {
            EObject o = (EObject) it.next();
            ModifyLink ml = (ModifyLink) o.eContainer();
            if (ml.getProperty() == r) {
                result.add(o);
            }
        }
        return result;
    }

    /**
     * 
     * getOppositeRemoveLinks
     * 
     * @param ownerID
     * @param r
     *            the opposite reference that points to the node with ownerID
     * @return
     * 
     * 
     */
    public Collection getOppositeRemoveLinks(String ownerID, EReference r) {
        Collection c = getOppositeRemoveLinks(ownerID);
        Collection result = new Vector();
        for (Iterator it = c.iterator(); it.hasNext();) {
            EObject o = (EObject) it.next();
            ModifyLink ml = (ModifyLink) o.eContainer();
            if (ml.getProperty() == r) {
                result.add(o);
            }
        }
        return result;
    }

    public NodeLevelSubDelta getNodeLevelSubDelta(String ownerID) {
        return (NodeLevelSubDelta) nodeLevelMap.get(ownerID);
    }

    private ModifyProp getModifyProp(String ownerID, EStructuralFeature f) {
        NodeLevelSubDelta sub = getNodeLevelSubDelta(ownerID);
        if (sub == null)
            return null;
        return getModifyProp(sub, f);
    }

    //    
    //    
    // public DerivedModifyLink getDerivedModifyLink(String ownerID, EReference
    // oppositeReference) {
    // NodeLevelSubDelta sub = getNodeLevelSubDelta(ownerID);
    // if(sub==null) return null;
    // if(!(sub instanceof Modify)) return null;
    // Modify mod = (Modify) sub;
    // return getDerivedModifyLink(mod, oppositeReference);
    // }
    //    

    public static ModifyProp getModifyProp(NodeLevelSubDelta modify,
            EStructuralFeature f) {
        for (Iterator it = modify.getContent().iterator(); it.hasNext();) {
            ModifyProp mp = (ModifyProp) it.next();
            if (f.equals(mp.getProperty())) {
                return mp;
            }
        }
        return null;
    }

    public static EReference getProperty(ModifyLinkElement e) {
        ModifyLink ml = (ModifyLink) e.eContainer();
        if (ml == null)
            return null;
        return (EReference) ml.getProperty();
    }

    public static String getOwnerID(SubDelta d) {
        EObject p = d;
        while (!(p instanceof NodeLevelSubDelta) && p != null) {
            p = p.eContainer();
        }
        if (p == null) {
            return null;
        }
        return ((NodeLevelSubDelta) p).getId();
    }

    public static Merge getMerge(SubDelta d) {
        EObject p = d.eContainer();
        while (p != null && !(p instanceof Merge)) {
            p = p.eContainer();
        }
        if (p == null)
            return null;
        return (Merge) p;
    }

    public static Delta getDelta(SubDelta s) {
        EObject o = s.eContainer();
        while (o != null && !(o instanceof Delta)) {
            o = o.eContainer();
        }
        return (Delta) o;
    }

    public static boolean isLocalSubDelta(SubDelta s) {
        Delta d = getDelta(s);
        if (d == null)
            return true;
        return d.isLocal();
    }

}
