/**
 * <copyright>
 * </copyright>
 *
 * $Id: MergeImpl.java,v 1.1 2006/05/17 12:12:11 xblanc Exp $
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;

import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.ConflictResolution;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.ConflictSet;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.Delta;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.Merge;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.MergePackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Merge</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.impl.MergeImpl#getLocalDelta <em>Local Delta</em>}</li>
 *   <li>{@link org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.impl.MergeImpl#getRemoteDelta <em>Remote Delta</em>}</li>
 *   <li>{@link org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.impl.MergeImpl#getConflict <em>Conflict</em>}</li>
 *   <li>{@link org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.impl.MergeImpl#getResolution <em>Resolution</em>}</li>
 *   <li>{@link org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.impl.MergeImpl#getRepository <em>Repository</em>}</li>
 *   <li>{@link org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.impl.MergeImpl#getResourceURL <em>Resource URL</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class MergeImpl extends EObjectImpl implements Merge {
    /**
     * The cached value of the '{@link #getLocalDelta() <em>Local Delta</em>}' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getLocalDelta()
     * @generated
     * @ordered
     */
    protected Delta localDelta = null;

    /**
     * The cached value of the '{@link #getRemoteDelta() <em>Remote Delta</em>}' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getRemoteDelta()
     * @generated
     * @ordered
     */
    protected Delta remoteDelta = null;

    /**
     * The cached value of the '{@link #getConflict() <em>Conflict</em>}' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getConflict()
     * @generated
     * @ordered
     */
    protected ConflictSet conflict = null;

    /**
     * The cached value of the '{@link #getResolution() <em>Resolution</em>}' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getResolution()
     * @generated
     * @ordered
     */
    protected ConflictResolution resolution = null;

    /**
     * The default value of the '{@link #getRepository() <em>Repository</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getRepository()
     * @generated
     * @ordered
     */
    protected static final String REPOSITORY_EDEFAULT = "default";

    /**
     * The cached value of the '{@link #getRepository() <em>Repository</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getRepository()
     * @generated
     * @ordered
     */
    protected String repository = REPOSITORY_EDEFAULT;

    /**
     * The default value of the '{@link #getResourceURL() <em>Resource URL</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getResourceURL()
     * @generated
     * @ordered
     */
    protected static final String RESOURCE_URL_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getResourceURL() <em>Resource URL</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getResourceURL()
     * @generated
     * @ordered
     */
    protected String resourceURL = RESOURCE_URL_EDEFAULT;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected MergeImpl() {
        super();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected EClass eStaticClass() {
        return MergePackage.eINSTANCE.getMerge();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Delta getLocalDelta() {
        return localDelta;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain basicSetLocalDelta(Delta newLocalDelta, NotificationChain msgs) {
        Delta oldLocalDelta = localDelta;
        localDelta = newLocalDelta;
        if (eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, MergePackage.MERGE__LOCAL_DELTA, oldLocalDelta, newLocalDelta);
            if (msgs == null) msgs = notification; else msgs.add(notification);
        }
        return msgs;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setLocalDelta(Delta newLocalDelta) {
        if (newLocalDelta != localDelta) {
            NotificationChain msgs = null;
            if (localDelta != null)
                msgs = ((InternalEObject)localDelta).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - MergePackage.MERGE__LOCAL_DELTA, null, msgs);
            if (newLocalDelta != null)
                msgs = ((InternalEObject)newLocalDelta).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - MergePackage.MERGE__LOCAL_DELTA, null, msgs);
            msgs = basicSetLocalDelta(newLocalDelta, msgs);
            if (msgs != null) msgs.dispatch();
        }
        else if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, MergePackage.MERGE__LOCAL_DELTA, newLocalDelta, newLocalDelta));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Delta getRemoteDelta() {
        return remoteDelta;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain basicSetRemoteDelta(Delta newRemoteDelta, NotificationChain msgs) {
        Delta oldRemoteDelta = remoteDelta;
        remoteDelta = newRemoteDelta;
        if (eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, MergePackage.MERGE__REMOTE_DELTA, oldRemoteDelta, newRemoteDelta);
            if (msgs == null) msgs = notification; else msgs.add(notification);
        }
        return msgs;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setRemoteDelta(Delta newRemoteDelta) {
        if (newRemoteDelta != remoteDelta) {
            NotificationChain msgs = null;
            if (remoteDelta != null)
                msgs = ((InternalEObject)remoteDelta).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - MergePackage.MERGE__REMOTE_DELTA, null, msgs);
            if (newRemoteDelta != null)
                msgs = ((InternalEObject)newRemoteDelta).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - MergePackage.MERGE__REMOTE_DELTA, null, msgs);
            msgs = basicSetRemoteDelta(newRemoteDelta, msgs);
            if (msgs != null) msgs.dispatch();
        }
        else if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, MergePackage.MERGE__REMOTE_DELTA, newRemoteDelta, newRemoteDelta));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public ConflictSet getConflict() {
        return conflict;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain basicSetConflict(ConflictSet newConflict, NotificationChain msgs) {
        ConflictSet oldConflict = conflict;
        conflict = newConflict;
        if (eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, MergePackage.MERGE__CONFLICT, oldConflict, newConflict);
            if (msgs == null) msgs = notification; else msgs.add(notification);
        }
        return msgs;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setConflict(ConflictSet newConflict) {
        if (newConflict != conflict) {
            NotificationChain msgs = null;
            if (conflict != null)
                msgs = ((InternalEObject)conflict).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - MergePackage.MERGE__CONFLICT, null, msgs);
            if (newConflict != null)
                msgs = ((InternalEObject)newConflict).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - MergePackage.MERGE__CONFLICT, null, msgs);
            msgs = basicSetConflict(newConflict, msgs);
            if (msgs != null) msgs.dispatch();
        }
        else if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, MergePackage.MERGE__CONFLICT, newConflict, newConflict));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public ConflictResolution getResolution() {
        return resolution;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain basicSetResolution(ConflictResolution newResolution, NotificationChain msgs) {
        ConflictResolution oldResolution = resolution;
        resolution = newResolution;
        if (eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, MergePackage.MERGE__RESOLUTION, oldResolution, newResolution);
            if (msgs == null) msgs = notification; else msgs.add(notification);
        }
        return msgs;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setResolution(ConflictResolution newResolution) {
        if (newResolution != resolution) {
            NotificationChain msgs = null;
            if (resolution != null)
                msgs = ((InternalEObject)resolution).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - MergePackage.MERGE__RESOLUTION, null, msgs);
            if (newResolution != null)
                msgs = ((InternalEObject)newResolution).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - MergePackage.MERGE__RESOLUTION, null, msgs);
            msgs = basicSetResolution(newResolution, msgs);
            if (msgs != null) msgs.dispatch();
        }
        else if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, MergePackage.MERGE__RESOLUTION, newResolution, newResolution));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getRepository() {
        return repository;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setRepository(String newRepository) {
        String oldRepository = repository;
        repository = newRepository;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, MergePackage.MERGE__REPOSITORY, oldRepository, repository));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getResourceURL() {
        return resourceURL;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setResourceURL(String newResourceURL) {
        String oldResourceURL = resourceURL;
        resourceURL = newResourceURL;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, MergePackage.MERGE__RESOURCE_URL, oldResourceURL, resourceURL));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
                case MergePackage.MERGE__LOCAL_DELTA:
                    return basicSetLocalDelta(null, msgs);
                case MergePackage.MERGE__REMOTE_DELTA:
                    return basicSetRemoteDelta(null, msgs);
                case MergePackage.MERGE__CONFLICT:
                    return basicSetConflict(null, msgs);
                case MergePackage.MERGE__RESOLUTION:
                    return basicSetResolution(null, msgs);
                default:
                    return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
            }
        }
        return eBasicSetContainer(null, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case MergePackage.MERGE__LOCAL_DELTA:
                return getLocalDelta();
            case MergePackage.MERGE__REMOTE_DELTA:
                return getRemoteDelta();
            case MergePackage.MERGE__CONFLICT:
                return getConflict();
            case MergePackage.MERGE__RESOLUTION:
                return getResolution();
            case MergePackage.MERGE__REPOSITORY:
                return getRepository();
            case MergePackage.MERGE__RESOURCE_URL:
                return getResourceURL();
        }
        return eDynamicGet(eFeature, resolve);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case MergePackage.MERGE__LOCAL_DELTA:
                setLocalDelta((Delta)newValue);
                return;
            case MergePackage.MERGE__REMOTE_DELTA:
                setRemoteDelta((Delta)newValue);
                return;
            case MergePackage.MERGE__CONFLICT:
                setConflict((ConflictSet)newValue);
                return;
            case MergePackage.MERGE__RESOLUTION:
                setResolution((ConflictResolution)newValue);
                return;
            case MergePackage.MERGE__REPOSITORY:
                setRepository((String)newValue);
                return;
            case MergePackage.MERGE__RESOURCE_URL:
                setResourceURL((String)newValue);
                return;
        }
        eDynamicSet(eFeature, newValue);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void eUnset(EStructuralFeature eFeature) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case MergePackage.MERGE__LOCAL_DELTA:
                setLocalDelta((Delta)null);
                return;
            case MergePackage.MERGE__REMOTE_DELTA:
                setRemoteDelta((Delta)null);
                return;
            case MergePackage.MERGE__CONFLICT:
                setConflict((ConflictSet)null);
                return;
            case MergePackage.MERGE__RESOLUTION:
                setResolution((ConflictResolution)null);
                return;
            case MergePackage.MERGE__REPOSITORY:
                setRepository(REPOSITORY_EDEFAULT);
                return;
            case MergePackage.MERGE__RESOURCE_URL:
                setResourceURL(RESOURCE_URL_EDEFAULT);
                return;
        }
        eDynamicUnset(eFeature);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case MergePackage.MERGE__LOCAL_DELTA:
                return localDelta != null;
            case MergePackage.MERGE__REMOTE_DELTA:
                return remoteDelta != null;
            case MergePackage.MERGE__CONFLICT:
                return conflict != null;
            case MergePackage.MERGE__RESOLUTION:
                return resolution != null;
            case MergePackage.MERGE__REPOSITORY:
                return REPOSITORY_EDEFAULT == null ? repository != null : !REPOSITORY_EDEFAULT.equals(repository);
            case MergePackage.MERGE__RESOURCE_URL:
                return RESOURCE_URL_EDEFAULT == null ? resourceURL != null : !RESOURCE_URL_EDEFAULT.equals(resourceURL);
        }
        return eDynamicIsSet(eFeature);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String toString() {
        if (eIsProxy()) return super.toString();

        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (repository: ");
        result.append(repository);
        result.append(", resourceURL: ");
        result.append(resourceURL);
        result.append(')');
        return result.toString();
    }

} //MergeImpl
