/**
 * <copyright>
 * </copyright>
 *
 * $Id: MergeSwitch.java,v 1.1 2006/05/17 12:12:15 xblanc Exp $
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.util;

import java.util.List;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.*;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.MergePackage
 * @generated
 */
public class MergeSwitch {
    /**
     * The cached model package
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected static MergePackage modelPackage;

    /**
     * Creates an instance of the switch.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public MergeSwitch() {
        if (modelPackage == null) {
            modelPackage = MergePackage.eINSTANCE;
        }
    }

    /**
     * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the first non-null result returned by a <code>caseXXX</code> call.
     * @generated
     */
    public Object doSwitch(EObject theEObject) {
        return doSwitch(theEObject.eClass(), theEObject);
    }

    /**
     * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the first non-null result returned by a <code>caseXXX</code> call.
     * @generated
     */
    protected Object doSwitch(EClass theEClass, EObject theEObject) {
        if (theEClass.eContainer() == modelPackage) {
            return doSwitch(theEClass.getClassifierID(), theEObject);
        }
        else {
            List eSuperTypes = theEClass.getESuperTypes();
            return
                eSuperTypes.isEmpty() ?
                    defaultCase(theEObject) :
                    doSwitch((EClass)eSuperTypes.get(0), theEObject);
        }
    }

    /**
     * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the first non-null result returned by a <code>caseXXX</code> call.
     * @generated
     */
    protected Object doSwitch(int classifierID, EObject theEObject) {
        switch (classifierID) {
            case MergePackage.MERGE: {
                Merge merge = (Merge)theEObject;
                Object result = caseMerge(merge);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case MergePackage.CONFLICT_SET: {
                ConflictSet conflictSet = (ConflictSet)theEObject;
                Object result = caseConflictSet(conflictSet);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case MergePackage.CONFLICT_RESOLUTION: {
                ConflictResolution conflictResolution = (ConflictResolution)theEObject;
                Object result = caseConflictResolution(conflictResolution);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case MergePackage.BASIC_CONFLICT_RESOLUTION: {
                BasicConflictResolution basicConflictResolution = (BasicConflictResolution)theEObject;
                Object result = caseBasicConflictResolution(basicConflictResolution);
                if (result == null) result = caseConflictResolution(basicConflictResolution);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case MergePackage.CONFLICT: {
                Conflict conflict = (Conflict)theEObject;
                Object result = caseConflict(conflict);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case MergePackage.DELTA: {
                Delta delta = (Delta)theEObject;
                Object result = caseDelta(delta);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case MergePackage.SUB_DELTA: {
                SubDelta subDelta = (SubDelta)theEObject;
                Object result = caseSubDelta(subDelta);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case MergePackage.NODE_LEVEL_SUB_DELTA: {
                NodeLevelSubDelta nodeLevelSubDelta = (NodeLevelSubDelta)theEObject;
                Object result = caseNodeLevelSubDelta(nodeLevelSubDelta);
                if (result == null) result = caseSubDelta(nodeLevelSubDelta);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case MergePackage.CREATE: {
                Create create = (Create)theEObject;
                Object result = caseCreate(create);
                if (result == null) result = caseNodeLevelSubDelta(create);
                if (result == null) result = caseSubDelta(create);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case MergePackage.DELETE: {
                Delete delete = (Delete)theEObject;
                Object result = caseDelete(delete);
                if (result == null) result = caseNodeLevelSubDelta(delete);
                if (result == null) result = caseSubDelta(delete);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case MergePackage.MODIFY_EXISTING: {
                ModifyExisting modifyExisting = (ModifyExisting)theEObject;
                Object result = caseModifyExisting(modifyExisting);
                if (result == null) result = caseNodeLevelSubDelta(modifyExisting);
                if (result == null) result = caseSubDelta(modifyExisting);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case MergePackage.MODIFY_PROP: {
                ModifyProp modifyProp = (ModifyProp)theEObject;
                Object result = caseModifyProp(modifyProp);
                if (result == null) result = caseSubDelta(modifyProp);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case MergePackage.MODIFY_PRIMITIVE: {
                ModifyPrimitive modifyPrimitive = (ModifyPrimitive)theEObject;
                Object result = caseModifyPrimitive(modifyPrimitive);
                if (result == null) result = caseModifyProp(modifyPrimitive);
                if (result == null) result = caseSubDelta(modifyPrimitive);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case MergePackage.MODIFY_LINK: {
                ModifyLink modifyLink = (ModifyLink)theEObject;
                Object result = caseModifyLink(modifyLink);
                if (result == null) result = caseModifyProp(modifyLink);
                if (result == null) result = caseSubDelta(modifyLink);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case MergePackage.MODIFY_LINK_ELEMENT: {
                ModifyLinkElement modifyLinkElement = (ModifyLinkElement)theEObject;
                Object result = caseModifyLinkElement(modifyLinkElement);
                if (result == null) result = caseSubDelta(modifyLinkElement);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case MergePackage.INSERT_LINK: {
                InsertLink insertLink = (InsertLink)theEObject;
                Object result = caseInsertLink(insertLink);
                if (result == null) result = caseModifyLinkElement(insertLink);
                if (result == null) result = caseSubDelta(insertLink);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case MergePackage.REMOVE_LINK: {
                RemoveLink removeLink = (RemoveLink)theEObject;
                Object result = caseRemoveLink(removeLink);
                if (result == null) result = caseModifyLinkElement(removeLink);
                if (result == null) result = caseSubDelta(removeLink);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            default: return defaultCase(theEObject);
        }
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>Merge</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>Merge</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public Object caseMerge(Merge object) {
        return null;
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>Conflict Set</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>Conflict Set</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public Object caseConflictSet(ConflictSet object) {
        return null;
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>Conflict Resolution</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>Conflict Resolution</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public Object caseConflictResolution(ConflictResolution object) {
        return null;
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>Basic Conflict Resolution</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>Basic Conflict Resolution</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public Object caseBasicConflictResolution(BasicConflictResolution object) {
        return null;
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>Conflict</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>Conflict</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public Object caseConflict(Conflict object) {
        return null;
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>Delta</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>Delta</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public Object caseDelta(Delta object) {
        return null;
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>Sub Delta</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>Sub Delta</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public Object caseSubDelta(SubDelta object) {
        return null;
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>Node Level Sub Delta</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>Node Level Sub Delta</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public Object caseNodeLevelSubDelta(NodeLevelSubDelta object) {
        return null;
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>Create</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>Create</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public Object caseCreate(Create object) {
        return null;
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>Delete</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>Delete</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public Object caseDelete(Delete object) {
        return null;
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>Modify Existing</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>Modify Existing</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public Object caseModifyExisting(ModifyExisting object) {
        return null;
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>Modify Prop</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>Modify Prop</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public Object caseModifyProp(ModifyProp object) {
        return null;
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>Modify Primitive</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>Modify Primitive</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public Object caseModifyPrimitive(ModifyPrimitive object) {
        return null;
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>Modify Link</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>Modify Link</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public Object caseModifyLink(ModifyLink object) {
        return null;
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>Modify Link Element</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>Modify Link Element</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public Object caseModifyLinkElement(ModifyLinkElement object) {
        return null;
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>Insert Link</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>Insert Link</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public Object caseInsertLink(InsertLink object) {
        return null;
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>Remove Link</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>Remove Link</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public Object caseRemoveLink(RemoveLink object) {
        return null;
    }

    /**
     * Returns the result of interpretting the object as an instance of '<em>EObject</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch, but this is the last case anyway.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpretting the object as an instance of '<em>EObject</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject)
     * @generated
     */
    public Object defaultCase(EObject object) {
        return null;
    }

} //MergeSwitch
