/*
 * $RCSfile: RepositoryRegistry.java,v $
 * $Date: 2006/05/16 11:43:12 $
 * $Revision: 1.1 $
 * $Author: xblanc $
 */
 
/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */
 
/*
 * RepositoryRegistry.java Add description 
 * 
 * @author Prawee Sriplakich
 * @version $Revision: 1.1 $ $Date: 2006/05/16 11:43:12 $
 * @see Add references
 *
 * TODO Add description
 * TODO Add references
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.merge.repository;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;

/**
 * This class keep tracks of all repository objects in the system.
 * Each repository is identified by an ID.
 * <br>
 * It also has the knowledge 
 * about the repository that manage each resource.
 * For example, it can tell that a file F1 is managed by the repository R1.
 * 
 * @author P. Sriplakich
 *
 */
public class RepositoryRegistry {
    
    static RepositoryRegistry instance = new RepositoryRegistry();
    
    
    public static RepositoryRegistry getInstance() {
        return instance;
    }
    
    public RepositoryRegistry() {   
    }
    
    protected Map map = new Hashtable();
    
    /**
     * 
     * get the Repository with the specified ID.
     * 
     * @param repositoryId
     * @return
     * 
     *
     */
    public IRepository getRepository(String repositoryId) {
        return (IRepository) map.get(repositoryId);
    }

    /**
     * 
     * get the Repository that manages the specified resource.
     * The current implementation returns the default repository
     * 
     * @param resourcePath
     * @return
     * 
     *
     */
    public IRepository getRepositoryForResource(String resourcePath) {
        return getRepository("default");
    }

    /**
     * 
     * register a Repository with a specified ID.
     * 
     * @param id
     * @param r
     * 
     *
     */
    public void registerRepository(IRepository r) {
        map.put(r.getRepositoryID(), r);
    }
    
    public Collection getAllReposities() {
        return map.values();
    }
}
