/*
 * $RCSfile: MergeModel2Text.java,v $
 * $Date: 2006/05/17 12:12:15 $
 * $Revision: 1.1 $
 * $Author: xblanc $
 */
 
/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */
 
/*
 * MergeModel2Text.java Add description 
 * 
 * @author Prawee Sriplakich
 * @version $Revision: 1.1 $ $Date: 2006/05/17 12:12:15 $
 * @see Add references
 *
 * TODO Add description
 * TODO Add references
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.merge.util;

import java.util.List;
import java.util.Properties;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.*;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.Conflict;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.Create;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.Delete;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.Delta;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.InsertLink;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.Merge;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.ModifyLink;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.ModifyLinkElement;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.ModifyPrimitive;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.NodeLevelSubDelta;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.SubDelta;

public class MergeModel2Text {
    
    ModelLabelProvider modelLabelProvider = new SimpleModelLabelProvider();
     
    
    public String getText(EObject o) {
        try {
            if(o==null) {
                return null;
            }
            if(o instanceof Merge) {
                    Merge m = (Merge) o;
                    modelLabelProvider.setMergeModel(m);
            }
            
            if(o instanceof NodeLevelSubDelta) {
                NodeLevelSubDelta d = (NodeLevelSubDelta) o;
                boolean isLocalModel =DeltaQuery.isLocalSubDelta(d);
                String modelElementLabel = modelLabelProvider.getText(d.getId(), isLocalModel);
//                if(!modelElementLabel.equals(d.getId())) {
//                    modelElementLabel = modelElementLabel +" ID:" + d.getId();
//                }
                if(o instanceof Create) {
                    return "create" + " " +modelElementLabel;
                }
                if(o instanceof Delete) {
                    return "delete" + " " +modelElementLabel;
                }
                return "modify" + " " + modelElementLabel;
            }
            if(o instanceof ModifyPrimitive) {
                ModifyPrimitive mp = (ModifyPrimitive) o;
                return "set " +showFeature(mp.getProperty()) +"="
                + mp.getValue();
            }
            if(o instanceof ModifyLink) {
                ModifyLink ml = (ModifyLink) o;
                return "ModifyLink " + showFeature(ml.getProperty());
            }
//            if(o instanceof DerivedModifyLink) {
//                DerivedModifyLink ml = (DerivedModifyLink) o;
//                return "DerivedModifyLink " + showFeature(ml.getProperty());                
//            }
            if(o instanceof ModifyLinkElement) {
                ModifyLinkElement elem = (ModifyLinkElement) o;
                boolean isLocalModel =DeltaQuery.isLocalSubDelta(elem);
                String list = showReferenceList(elem.getRef(), isLocalModel);           
                EReference r = DeltaQuery.getProperty(elem);
                if(r!=null && r.isOrdered() && (elem instanceof InsertLink)) {
                  InsertLink il = (InsertLink) elem;
                  String position = (il.getPosAfter()==null)? "@begin"
                          : "after " +
                          modelLabelProvider.getText(il.getPosAfter(), isLocalModel);
                  return "InsertLink " +list +" " + position; 
                } else {
                   return elem.eClass().getName() +" " +list;
                }
            } 
            
            if(o instanceof Conflict) { 
                Conflict conf = (Conflict) o;
                return showConflict(conf);
            }
            
            if(o instanceof Delta) {
                Delta d = (Delta) o;
                EStructuralFeature f = d.eContainingFeature();
                if(f!=null) {
                    return f.getName();
                } else {
                    return "Delta";
                }
            }
            return SimpleModelLabelProvider.getObjectTypeAndName(o);
            
          } catch(Exception e) {
              e.printStackTrace();
          }
          return null;                
    }
    
    public String showConflict(Conflict conf) {
        
        StringBuffer buf = new StringBuffer();
        buf.append(conf.getType() +" ");
        if(!conf.getLocal().isEmpty() && BasicConflictHandler.isAllCanceled(conf.getLocal())) {
            buf.append("(canceled) ");
        }
        buf.append(showSubDeltaList(conf.getLocal()));
        buf.append(" | ");
        if (!conf.getRemote().isEmpty() && BasicConflictHandler.isAllCanceled(conf.getRemote())) {
            buf.append("(canceled) ");
        }        
        buf.append(showSubDeltaList(conf.getRemote()));
        return buf.toString();        
    }
    
   
    
    public String showFeature(EStructuralFeature f) {
        if(f==null) return "null";
        return f.getName();
    }
    
    public String showSubDeltaList(List l) {
        StringBuffer buf = new StringBuffer();
        for(int i=0; i<l.size(); i++) {
            SubDelta d = (SubDelta) l.get(i);
            if(i==0) {
              buf.append( getText(d));
            } else {
              buf.append(" ," +getText(d) );
            }
        }
        return buf.toString();
    }   
    
    public String showReferenceList(List ids, boolean isLocalModel) {
        StringBuffer buf = new StringBuffer();
        buf.append("{");
        for(int i=0; i<ids.size(); i++) {
            String id = (String) ids.get(i);
            String rep = modelLabelProvider.getText(id, isLocalModel);
            if(i==0) {
              buf.append( rep);
            } else {
              buf.append(" ," +rep);  
            }
        }
        buf.append("}");
        return buf.toString();
    }    
    
       

}
