/*
 * $RCSfile: SimpleModelLabelProvider.java,v $
 * $Date: 2006/05/17 12:12:15 $
 * $Revision: 1.1 $
 * $Author: xblanc $
 */
 
/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */
 
/*
 * SimpleModelLabelProvider.java Add description 
 * 
 * @author Prawee Sriplakich
 * @version $Revision: 1.1 $ $Date: 2006/05/17 12:12:15 $
 * @see Add references
 *
 * TODO Add description
 * TODO Add references
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.merge.util;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.MergeData;
import org.eclipse.mddi.modelbus.adapter.infrastructure.merge.model.Merge;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.ModelUtil;

public class SimpleModelLabelProvider implements ModelLabelProvider {

    MergeData mergeData;
    
    public void setMergeModel(Merge m) {
        mergeData = (MergeData) ModelUtil.findAdapter(m, MergeData.class);
    }

    public String getText(String id, boolean isLocalModel) {
        if(mergeData==null) {
            return id;
        }
        EObject o = null;
        if(isLocalModel) {
           o = mergeData.getLocalVariant().getEObject(id);
        } else {
           o = mergeData.getRemoteVariant().getEObject(id);
        }
        if(o==null) {
            // The deleted object does not exist in the updated variant (remote / local)
            // get the object from the base variant.
            o = mergeData.getBaseVariant().getEObject(id);
        }
        return getObjectTypeAndNameOrId(o, id);
    }
    
    
    public static String getObjectTypeAndNameOrId(EObject o, String id) {
        if(o==null) {
            return id;
        }
        EStructuralFeature f = o.eClass().getEStructuralFeature("name");
        if(f!=null) {
            return o.eClass().getName() + "_" +o.eGet(f);
        }
        return id;        
    }

    public static String getObjectTypeAndName(EObject o) {
        if(o==null) {
            return "null";
        }
        EStructuralFeature f = o.eClass().getEStructuralFeature("name");
        if(f!=null) {
            return o.eClass().getName() + "_" +o.eGet(f);
        }
        return o.eClass().getName();
    }

}
