package org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.SAXXMIHandler;

/*
 * $RCSfile: UUIDSAXXMIHandler.java,v $ $Date: 2006/06/20 15:49:01 $ $Revision: 1.1 $ $Author: xblanc $
 */

/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus. All rights
 * reserved.
 * 
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

/*
 * UUIDSAXXMIHandler.java handles xmi:uuid, xmi:Extension, xmi:Documentation
 * 
 * @author Andrey Sadovykh (LIP6)
 * 
 * @version $Revision: 1.1 $ $Date: 2006/06/20 15:49:01 $
 */

/*
 * UUIDSAXXMIHandler
 *  
 */

public class UUIDSAXXMIHandler extends SAXXMIHandler {

    protected static Set extensionFeatures;

    protected static final String XMI_DOCUMENTATION = "Documentation";

    /**
     * @param xmiResource
     * @param helper
     * @param options
     */
    public UUIDSAXXMIHandler(XMLResource xmiResource, XMLHelper helper,
            Map options) {
        super(xmiResource, helper, options);

        notFeatures.remove(UUID_ATTRIB);

        extensionFeatures = new HashSet();
        extensionFeatures.add(XMI_EXTENSION);
        extensionFeatures.add(XMI_UUID);
        extensionFeatures.add(XMI_DOCUMENTATION);
    }

    protected void handleUnknownFeature(String prefix, String name,
            boolean isElement, EObject peekObject, String value) {

        if (extensionFeatures.contains(name)) {
            if (extendedMetaData == null) {
                setExtendedMetaDataOption(Boolean.TRUE);
            }

            recordUnknownFeature(prefix, name, isElement, peekObject, value);

        } else
            super.handleUnknownFeature(prefix, name, isElement, peekObject,
                    value);
    }

}
