/*
 * $RCSfile: DefaultModelSerializer.java,v $
 * $Date: 2006/06/02 15:01:00 $
 * $Revision: 1.2 $
 * $Author: xblanc $
 */

/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

/*
 * DefaultSerializer.java implements for prameter serialisation methods
 * 
 * @author Andrey Sadovykh (LIP6)
 * @version $Revision: 1.2 $ $Date: 2006/06/02 15:01:00 $
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.emf_xmi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.GlobalResourceRegistry;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.ModelBusResourceSet;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.ModelUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.*;
import org.eclipse.mddi.modelbus.description.abstract_.ModelType;
import org.eclipse.mddi.modelbus.description.abstract_.Parameter;


/*
 * DefaultSerializer
 * 
 */

public class DefaultModelSerializer implements ModelSerializer {

    private static Logger logger = Logger.getLogger(DefaultModelSerializer.class);

    protected boolean skipCrossReferences = false;

    /**
     * the prefixes of the resource URIs that be NOT be serialized, 
     * as cross-referenced resources.
     * The default value is {"pathmap://ModelBus" , "http://"  }.
     * <br>
     */
    protected Collection ignoredUriPrefixSet = new Vector(GlobalResourceRegistry.GLOBAL_URI_PREFIX_SET);


    /**
     * 
     */
    public DefaultModelSerializer() {
        super();
    }
    
    /**
     * defines wheter ModelBus can change resource URI
     * if it needs to serialize resources having the same URI.
     */
    public boolean canChangeURI = true;
    


    /**
     * @return Returns the skipCrossReferences.
     */
    public boolean isSkipCrossReferences() {
        return skipCrossReferences;
    }

    /**
     * @param skipCrossReferences
     *            The skipCrossReferences to set.
     */
    public void setSkipCrossReferences(boolean skipCrossReferences) {
        this.skipCrossReferences = skipCrossReferences;
    }

    /**
     * @return Returns the ignoredUriPrefixSet.
     */
    public Collection getIgnoredUriPrefixSet() {
        return ignoredUriPrefixSet;
    }

    public SerializedXmiDocument[] serialize(Parameter[] params, Object[] values) {
        Collection allModelElements = getScope(params, values);
        Resource[] res = ModelUtil.getResourcesFromObjects(allModelElements,
                skipCrossReferences, ignoredUriPrefixSet);
        return serializeResources(res);
    }
    
    
    public Collection getScope(Parameter[] params, Object[] values) {
        Collection allModelElements = new Vector();
        for (int i = 0; i < params.length; i++) {
            if (params[i].getType() instanceof ModelType) {
                if (params[i].getUpper() == 1) {
                    allModelElements.addAll((Collection) values[i]);
                } else {
                    Collection[] modelArray = (Collection[]) values[i];
                    for (int j = 0; j < modelArray.length; j++) {
                        allModelElements.addAll(modelArray[j]);
                    }
                }
            }
        }        
        return allModelElements;
    }
    
    
    public SerializedXmiDocument[] serializeResources(Resource[] res) {
        Set uris = new HashSet(); // used for checking redundant URIs
        Vector docVector = new Vector();        
        for(int i=0; i<res.length; i++) {
            try {
                SerializedXmiDocument doc = new SerializedXmiDocument();
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                res[i].save(bout, null);
                doc.setXmi(bout.toString());
                String uri = res[i].getURI().toString();
                while(canChangeURI && uris.contains(uri)) {
                    uri = "_" + uri;
                    res[i].setURI( URI.createURI( "_" +uri ));
                    logger.error("Redundant URI. Changed to " + uri );                    
                }
                doc.setUri(uri);
                uris.add(uri);
                docVector.add(doc);
            } catch (Exception e) {
                logger.error(e);
            }
        }
        return (SerializedXmiDocument[]) docVector
            .toArray(new SerializedXmiDocument[docVector.size()]);        
    }

    public DeserializedModel[] deserialize(SerializedXmiDocument[] documents) {
        DeserializedModel[] result = new DeserializedModel[documents.length];
        ResourceSet rs = new ModelBusResourceSet();
        for(int i=0; i<documents.length; i++) {
            result[i] = new DeserializedModel();
            result[i].setUri( documents[i].getUri() );
            try {
               ByteArrayInputStream bin = new ByteArrayInputStream( 
                        documents[i].getXmi().getBytes() );               
               Resource r = rs.createResource( 
                       URI.createURI(documents[i].getUri()) ); 
               r.load(bin, null);
               result[i].setValue(r);
            } catch(Exception e) {
                logger.error(e);
            }
        }
        return result;
    }

    public ModelElementReference[] getReferences(
            SerializedXmiDocument[] documents, Parameter p, Object o) {
        Collection c = (Collection) o;
        Vector v = new Vector();
        for(Iterator it = c.iterator(); it.hasNext(); ) {
            EObject eo = (EObject) it.next();
            Resource r = eo.eResource();
            ModelElementReference ref = new ModelElementReference();
            ref.setUri(r.getURI().toString());
            ref.setRef(r.getURIFragment(eo));
            v.add(ref);
        }
        return (ModelElementReference[]) v.toArray(new ModelElementReference[v.size()]);
    }
    
    

    public Object dereference(
            DeserializedModel[] data, Parameter p, ModelElementReference[] refs) {
        Vector v = new Vector();
        for(int i=0; i<refs.length; i++ ) {
            String uri = refs[i].getUri();
            String ref = refs[i].getRef();
            boolean foundResource = false;
            for(int j=0; j<data.length; j++) {
              if(data[j].getUri().equals(uri)) {
                 foundResource = true;
                 Resource r = (Resource) data[j].getValue();
                 try {
                     EObject eo = null;
                     eo = r.getEObject(ref);
                     if(eo!=null) {
                         v.add(eo); break;
                     }
                     logger.error("Fragment Not Found " +uri +", "+ ref);  
                 } catch(Exception e) {
                     logger.error(e);
                 }
                 v.removeAll(r.getContents());
                 v.addAll(r.getContents());
              }   
            }
            if(!foundResource) {
                logger.error("Resource Not Found " + uri);
            }
        }
        return v;
    }
    
    
    

    /**
     * @return Returns the canChangeURI.
     */
    public boolean canChangeURI() {
        return canChangeURI;
    }

    /**
     * @param canChangeURI The canChangeURI to set.
     */
    public void setCanChangeURI(boolean canChangeURI) {
        this.canChangeURI = canChangeURI;
    }
    
   
}
