/*
 * $RCSfile: ProviderProxy.java,v $
 * $Date: 2006/07/28 16:16:31 $
 * $Revision: 1.5 $
 * $Author: xblanc $
 */

/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

/*
 * AbstractInvocationSender.java Add description 
 * 
 * @author Prawee Sriplakich (LIP6)
 * @version $Revision: 1.5 $ $Date: 2006/07/28 16:16:31 $
 * @see Add references
 *
 * TODO Add description
 * TODO Add references
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.transport;

import org.eclipse.mddi.modelbus.adapter.infrastructure.axisasync.NoAsyncConnectionFoundException;
import org.eclipse.mddi.modelbus.adapter.infrastructure.axisasync.ResultNotReadyException;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.marshal.ws.Marshaler;
import org.eclipse.mddi.modelbus.adapter.user.ModelingServiceError;
import org.eclipse.mddi.modelbus.adapter.user.consumer.ModelBusCommunicationException;
import org.eclipse.mddi.modelbus.adapter.user.consumer.ModelTypeMismatchException;
import org.eclipse.mddi.modelbus.adapter.user.consumer.NoToolAvailableException;
import org.eclipse.mddi.modelbus.adapter.user.consumer.ServiceUnknownException;
import org.eclipse.mddi.modelbus.description.abstract_.ModelingService;
import org.eclipse.mddi.modelbus.description.concrete.Tool;


public interface ProviderProxy {
    
    public Tool getToolDescription();
    
    
    public void setToolDescription(Tool t);
    
    /**
     * @return Returns the marshaler.
     */
    public Marshaler getMarshaler();

    /**
     * @param marshaler The marshaler to set.
     */
    public void setMarshaler(Marshaler marshaler); 
    
    /**
     * Manages Service invocation at client side.
     * 
     * The implementation of this method can realize either local invocation 
     * or web service invocation
     * 
     * @param toolDescription the description of Provider Tool
     * @param ms the description of Modeling Service
     * @param inputs The inputs of the invocation
     * @return the outputs of the invocation
     * 
     * @throws ServiceUnknownException
     * @throws NoToolAvailableException
     * @throws ModelTypeMismatchException
     * @throws ModelBusCommunicationException
     * @throws ModelingServiceError
     * @throws Exception 
     */
    public Object[] invoke(ModelingService ms,
            Object[] inputs) throws ServiceUnknownException,
            NoToolAvailableException, ModelTypeMismatchException,
            ModelBusCommunicationException, ModelingServiceError;
    
    
    
    public String invokeAsync(ModelingService ms,
            Object[] inputs) throws ServiceUnknownException,
            NoToolAvailableException, ModelTypeMismatchException,
            ModelBusCommunicationException, ModelingServiceError;
    
    public boolean isResultReady(String resultHolderId)throws NoAsyncConnectionFoundException,ServiceUnknownException,
    NoToolAvailableException, ModelTypeMismatchException,
    ModelBusCommunicationException,ModelingServiceError;
    
    public Object[] getResult(String resultHolderId)throws ResultNotReadyException,NoAsyncConnectionFoundException,ServiceUnknownException,
    NoToolAvailableException, ModelTypeMismatchException,
    ModelBusCommunicationException,ModelingServiceError;

}