/*
 * $RCSfile: TransportManager.java,v $
 * $Date: 2006/05/17 13:01:08 $
 * $Revision: 1.8 $
 * $Author: xblanc $
 */

/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

/*
 * TransportManager.java 
 * 
 * @author Prawee Sriplakich, Andrey Sadovykh (LIP6)
 * @version $Revision: 1.8 $ $Date: 2006/05/17 13:01:08 $
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.transport;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;

import org.apache.log4j.Logger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.AdapterContainerImpl;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.DescriptionUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.ModelSerializer;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.modelbus_xmi.FragmentSerializer;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.client.AbstractInvocationSender;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.client.local.LocalInvocationSender;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.client.local.LocalSessionInvocationSender;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.client.ws.DefaultSessionWsInvocationSender;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.client.ws.DefaultWsInvocationSender;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.server.ws.DefaultSessionWsInvocationReceiver;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.server.ws.DefaultWsInvocationReceiver;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.server.ws.WsInvocationReceiver;
import org.eclipse.mddi.modelbus.adapter.user.AdapterStub;
import org.eclipse.mddi.modelbus.description.concrete.Tool;

/**
 * 
 * The responsibility of this class is to chooses the mechanisms corresponding
 * to the options specified in the Adapter stub. It contains some definition of
 * properties that can be use to customized the invocation style
 * 
 * @author P. Sriplakich, Andrey Sadovykh (LIP6)
 * 
 * 
 */
public class TransportManager {

    private static Logger logger = Logger.getLogger(TransportManager.class);

    SessionManager sessionManager = new SessionManager();

    Map toolDesc_proxy = new Hashtable();

    AdapterStub adapter;

    /**
     * Factory for creating custom serializer to replace the default one
     */
    ModelSerializer modelSerializer = null;

    public TransportManager(AdapterStub adapter) {
        this.adapter = adapter;
    }

    /**
     * 
     * This method is call to invoke a service locally or remotely.
     * 
     * @return
     * 
     * 
     */
    public ProviderProxy getProviderProxy(Tool t) {
        ProviderProxy p = null;

        // if local AdapterContainer contains Tool t
        if (AdapterContainerImpl.getInstance().containsTool(t)) {

            logger.debug("Local Call");

            p = new LocalInvocationSender(adapter.getProperties());
        } else {
            p = new DefaultWsInvocationSender(adapter.getProperties());
        }
        
        p.setToolDescription(t);

        if (modelSerializer != null) {
            logger.debug("setSerializer"
                    + modelSerializer.getClass().getName());
            p.getMarshaler().setSerializer(
                    modelSerializer);
        }
        //logger.debug("Marshaler:" + p.getMarshaler());

        return p;
    }

    public SessionProviderProxy getSessionProviderProxy(Tool t) {
        SessionProviderProxy p = null;
        if (!DescriptionUtil.getIsSessionEnabled(t))
            return p;
        // if local AdapterContainer contains Tool t
        if (AdapterContainerImpl.getInstance().containsTool(t)) {
            p = new LocalSessionInvocationSender(adapter.getProperties());
        } else
            p = new DefaultSessionWsInvocationSender(adapter.getProperties());

        p.setSessionManager(this.sessionManager);
        p.setToolDescription(t);

        if (modelSerializer != null)
            p.getMarshaler().setSerializer(
                    modelSerializer);
        return p;
    }

    public void removeProviderProxy(ProviderProxy p) {
        toolDesc_proxy.values().remove(p);

    }

    public Collection getAllProviderProxies() {
        return toolDesc_proxy.values();
    }



    public WsInvocationReceiver getWsInvocationReceiver() {
        String style = adapter.getProperties().getProperty(
                AdapterStub.PROP_invocationStyle,
                AdapterStub.PROP_invocationStyle_Default);

        WsInvocationReceiver r;

        if (DescriptionUtil.getIsSessionEnabled(adapter.getToolDescription())) {
            // Session case
            r = new DefaultSessionWsInvocationReceiver(adapter);
        } else {
            r = new DefaultWsInvocationReceiver(adapter);
        }
        
        if (modelSerializer != null) {
            logger.debug("setSerializer "
                    + modelSerializer.getClass().getName());
            r.getMarshaler().setSerializer(
                    modelSerializer);
        }
        
        return r;
    }

    /**
     * @return Returns the sessionManager.
     */
    public SessionManager getSessionManager() {
        return sessionManager;
    }

    /**
     * @return Returns the serializer.
     */
    public ModelSerializer getModelSerializer() {
        return modelSerializer;
    }

    /**
     * @param serializer
     *            The serializer to set.
     */
    public void setModelSerializer(
            ModelSerializer modelSerializer) {
        this.modelSerializer = modelSerializer;
    }

}
