/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

/*
 * Created on 15 juin 2005
 *
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.transport.client.ws;

import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;

import org.apache.log4j.Logger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.axisasync.AsyncConnectionManager;
import org.eclipse.mddi.modelbus.adapter.infrastructure.axisasync.NoAsyncConnectionFoundException;
import org.eclipse.mddi.modelbus.adapter.infrastructure.axisasync.ResultNotReadyException;
import org.eclipse.mddi.modelbus.adapter.infrastructure.axisasync.SOAPAsyncConnection;
import org.eclipse.mddi.modelbus.adapter.infrastructure.axisasync.ThreadPoolQueue;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.DescriptionUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.client.AbstractInvocationSender;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.marshal.ws.DefaultMarshaler;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.marshal.ws.SoapUtil;
import org.eclipse.mddi.modelbus.adapter.user.ModelingServiceError;
import org.eclipse.mddi.modelbus.adapter.user.consumer.ModelBusCommunicationException;
import org.eclipse.mddi.modelbus.adapter.user.consumer.ModelTypeMismatchException;
import org.eclipse.mddi.modelbus.adapter.user.consumer.NoToolAvailableException;
import org.eclipse.mddi.modelbus.adapter.user.consumer.ServiceUnknownException;
import org.eclipse.mddi.modelbus.description.abstract_.Error;
import org.eclipse.mddi.modelbus.description.abstract_.ModelingService;
import org.eclipse.mddi.modelbus.description.abstract_.Parameter;






/**
 * 
 * 
 * @author Prawee Sriplakich, Andrey Sadovykh (LIP6)
 * 
 * 
 */
public class DefaultWsInvocationSender extends AbstractInvocationSender {

    private static Logger logger = Logger
            .getLogger(DefaultWsInvocationSender.class);

//TODO 
	protected static final int DEFAULT_WORKING_THREADS_NUMBER = 20;
	protected static Map connexionId2modelingService = new Hashtable();

//TODO
	protected static ThreadPoolQueue poolQueue = null;
	
	


    

    public SOAPMessage requestMsg;

    public SOAPMessage responseMsg;

    public String targetUrl;

    // an array of in/inout parameter values
    // if usesScope option is set, it must contain two extra elements:
    // "inScope", "inoutScope";
    public Object[] unmarshalledInputs;

    // an array of out/inout parameter values
    public Object[] unmarshalledOutputs;

    public ModelingService ms;
    
    
    //NG
    public String connectionId;
    //NG

    public DefaultWsInvocationSender(Properties prop) {
        if (getMarshaler() == null)
            setMarshaler(new DefaultMarshaler(prop));
    }	
    

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.mddi.modelbus.adapter.user.provider.WsInvocationSender#invoke(org.eclipse.mddi.modelbus.description.concrete.Tool,
     *      org.eclipse.mddi.modelbus.description.abstract_.ModelingService,
     *      java.lang.Object[])
     */
    public Object[] invoke(ModelingService ms, Object[] inputs)
            throws ServiceUnknownException, NoToolAvailableException,
            ModelTypeMismatchException, ModelBusCommunicationException,
            ModelingServiceError {

        this.targetUrl = DescriptionUtil.getProperty(getToolDescription(),
                "URL");
        this.ms = ms;
        this.unmarshalledInputs = inputs;
        try {
        this.responseMsg = SoapUtil.messageFactory.createMessage();
        

     
            createRequestMessage();
            makeConnection();
            readResponseMessage();
            return unmarshalledOutputs;

        } catch (SOAPException e) {
            //logger.error(e);
            e.printStackTrace();
            throw new ModelBusCommunicationException("targetUrl=" + targetUrl
                    + " " + e.getMessage(), e);

        }

    }

    public void createRequestMessage() throws ModelBusCommunicationException,
            ModelTypeMismatchException {

        if (requestMsg == null)
            try {
                requestMsg = SoapUtil.messageFactory.createMessage();
                SOAPBody requestbody = requestMsg.getSOAPBody();
                DefaultMarshaler.setNamespaces(requestbody);
                SOAPElement reqTopElem = requestbody.addChildElement(ms
                        .getName(), "modelbus");
                List inputParams = DescriptionUtil.get_in_inout_Parameters(ms);

                // marshal parameters
                Parameter[] params = (Parameter[]) inputParams
                        .toArray(new Parameter[inputParams.size()]);

                //logger.debug("Serializer:"+getMarshaler().getSerializer());

                getMarshaler().marshal(params, unmarshalledInputs, reqTopElem);
            } catch (Exception e) {
                throw new ModelBusCommunicationException(
                        "Can't create request message", e);
            }

    }

    public void makeConnection() throws SOAPException {

        logger.debug("Call URL: " + targetUrl);

        SOAPConnection con = SoapUtil.connectionFactory.createConnection();

        logger.debug("Call with Message: "
                + requestMsg.getSOAPBody().toString());

        responseMsg = con.call(requestMsg, targetUrl);

        con.close();

        logger.debug("Response Message: "
                + responseMsg.getSOAPBody().toString());

    }

    // unmarshall response message
    public void readResponseMessage() throws ModelBusCommunicationException,
            ModelingServiceError {

        SOAPBody responsebody = null;
        try {

      
            responsebody = responseMsg.getSOAPBody();
        } catch (SOAPException e1) {
            throw new ModelBusCommunicationException(
                    "Can't parse response message", e1);
        }
        if (responsebody.hasFault()) {
        	
            SOAPFault f = responsebody.getFault();
            if (DefaultMarshaler.isModelingServiceError(f)) {

                String errorName = DefaultMarshaler
                        .getModelingServiceErrorName(f);
                Error errorType = null;
                if (errorName != null)
                    errorType = DescriptionUtil.getError(ms, errorName);

                ModelingServiceError err = null;

                try {
                    err = getMarshaler().unmarshalModelingServiceError(
                            errorType, f);
                } catch (SOAPException e) {
                    logger.error("Can't unmarshal ModelingServiceError", e);
                }
                throw err;
                
            } else {
                throw new ModelBusCommunicationException(f.toString()
                        + "[ uri = " + targetUrl + "]");
            }
            
            
        } else {
            SOAPElement resTopElem = SoapUtil.getFirstChild(responsebody);
            if (resTopElem == null) {
                logger.error("Empty SOAP response");
                logger.debug(responsebody.toString());
                throw new ModelBusCommunicationException("Empty SOAP response");
            }

            // unmarchal params
            List outputParams = DescriptionUtil.get_out_inout_Parameters(ms);

            Parameter[] params = new Parameter[outputParams.size()];
            for (int i = 0; i < outputParams.size(); i++)
                params[i] = (Parameter) outputParams.get(i);
            try {
                unmarshalledOutputs = getMarshaler().unmarshal(params,
                        resTopElem);
            } catch (Exception e) {
                throw new ModelBusCommunicationException(
                        "Can't unmarshal response message", e);
            }
        }
    }
	
	

    
 //NG
	public String invokeAsync(ModelingService ms, Object[] inputs)
	throws ServiceUnknownException, NoToolAvailableException,
	ModelTypeMismatchException, ModelBusCommunicationException,
	ModelingServiceError {
		
		String targetUrl = DescriptionUtil.getProperty(getToolDescription(),"URL");
		
		this.ms = ms;
		this.unmarshalledInputs = inputs;
        this.targetUrl = DescriptionUtil.getProperty(getToolDescription(),
        "URL");
        
        try {
//TODO
        	if(poolQueue == null)
        		createThreadPoolQueue();
        	
            this.responseMsg = SoapUtil.messageFactory.createMessage();
            
			createRequestMessage();
			makeAsyncConnection();
			return connectionId;
			
		} catch (SOAPException e) {
			throw new ModelBusCommunicationException( "targetUrl=" + targetUrl +" " +e.getMessage(), e);
		}
		
	}
	
//NG
	

//NG
	
	public void makeAsyncConnection() throws SOAPException {
		
		
		SOAPAsyncConnection con = SoapUtil.asyncConnectionFactory.createAsyncConnection();			
	
		connectionId = con.call(requestMsg, targetUrl,poolQueue);
		
		AsyncConnectionManager.getInstance().putAsyncConnection(connectionId,con);

		connexionId2modelingService.put(connectionId,ms); 
		// to make the ms avaible from the getResult() method, mandatory to unmarshall the message

	}
//NG	

	
	public void closeAsyncConnection(String connexionId) throws SOAPException, NoAsyncConnectionFoundException{
		SOAPAsyncConnection con = AsyncConnectionManager.getInstance().getAsyncConnection(connexionId);
		// closing the connection
		con.close();
		AsyncConnectionManager.getInstance().removeAsyncConnection(con.hashCode()+"");
		
		// removing the binding connexionId-Ms from the map
		connexionId2modelingService.remove(connexionId);
		
		
	}
	


	
	public boolean isResultReady(String connexionId) throws ServiceUnknownException, NoToolAvailableException, ModelTypeMismatchException, ModelBusCommunicationException,NoAsyncConnectionFoundException, ModelingServiceError {
		
		boolean resultReady = false;
		
		try {
			SOAPAsyncConnection con = AsyncConnectionManager.getInstance().getAsyncConnection(connexionId);
			resultReady = con.isResultReady();	
		} catch (NoAsyncConnectionFoundException e) {
			e.printStackTrace();
		}
		return resultReady;
	}
	

	
	public Object[] getResult(String connexionId) throws ResultNotReadyException, NoAsyncConnectionFoundException, ServiceUnknownException, NoToolAvailableException, ModelTypeMismatchException, ModelBusCommunicationException, ModelingServiceError {
		
		
		try {

			SOAPAsyncConnection con = AsyncConnectionManager.getInstance().getAsyncConnection(connexionId);
			responseMsg = (SOAPMessage) con.getResult();
			
			// unmarshalling
			ModelingService ms = (ModelingService) connexionId2modelingService.get(connexionId);
			if(ms==null)
				throw new Exception("ModelingService not avaible");
			readResponseMessage();
			
			// the getResultMethod can be called only once
			closeAsyncConnection(connexionId);
			
			//TODO
			//if the queue is empty, we close the threadpool
			if(poolQueue.isEmpty())
				closeThreadPoolQueue();
			
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		return unmarshalledOutputs;
	}
	
	//TODO
	public static void closeThreadPoolQueue(){
		poolQueue.close();
		poolQueue = null;
	}
	
	//TODO
	public static void createThreadPoolQueue(){
		poolQueue = new ThreadPoolQueue(DEFAULT_WORKING_THREADS_NUMBER);
	}
	
	
}