/*
 * $RCSfile: DefaultSessionMarshaler.java,v $
 * $Date: 2006/04/12 15:37:14 $
 * $Revision: 1.3 $
 * $Author: xblanc $
 */

/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

/*
 * DefaultSessionMarshaler.java Add description 
 * 
 * @author Andrey Sadovykh (LIP6)
 * @version $Revision: 1.3 $ $Date: 2006/04/12 15:37:14 $
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.transport.marshal.ws;

import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;

import javax.xml.soap.SOAPElement;

import org.apache.log4j.Logger;
import org.eclipse.mddi.modelbus.description.abstract_.Parameter;

public class DefaultSessionMarshaler extends DefaultMarshaler {

    private Logger logger = Logger.getLogger(DefaultSessionMarshaler.class);

    public static final String SESSION_ID_TAG = "modelbus:sessionId";

    private String sessionId = null;

    
    public DefaultSessionMarshaler(Properties p) {
        super(p);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.mddi.modelbus.adapter.infrastructure.transport.marshal.ws.AbstractMarshaler#marshal(org.eclipse.mddi.modelbus.description.abstract_.Parameter[],
     *      java.lang.Object[], javax.xml.soap.SOAPElement)
     */
    public void marshal(Parameter[] params, Object[] parameterValues,
            SOAPElement topElem) throws Exception {
        SOAPElement topSoapElem = topElem.addChildElement(SESSION_ID_TAG);
        topSoapElem.addTextNode(sessionId);
        super.marshal(params, parameterValues, topElem);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.mddi.modelbus.adapter.infrastructure.transport.marshal.ws.AbstractMarshaler#unmarshal(org.eclipse.mddi.modelbus.description.abstract_.Parameter[],
     *      javax.xml.soap.SOAPElement)
     */
    public Object[] unmarshal(Parameter[] params, SOAPElement topElem)
            throws Exception {
        Iterator it = topElem.getChildElements();
        SOAPElement sessionEl = (SOAPElement) it.next();
        if (sessionEl.getNodeName().matches(SESSION_ID_TAG)) {
            // retrieve and remove sessionId
            sessionId = sessionEl.getValue();
            topElem.removeChild(sessionEl);
        }
        return super.unmarshal(params, topElem);
    }

    /**
     * @return Returns the sessionId.
     */
    public String getSessionId() {
        return sessionId;
    }

    /**
     * @param sessionId
     *            The sessionId to set.
     */
    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

}
