/*
 * $RCSfile: Marshaler.java,v $
 * $Date: 2006/05/16 11:43:12 $
 * $Revision: 1.6 $
 * $Author: xblanc $
 */

/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

/*
 * ParameterMarshaler.java Add description 
 * 
 * @author Prawee Sriplakich, Andrey Sadovykh (LIP6)
 * @version $Revision: 1.6 $ $Date: 2006/05/16 11:43:12 $
 */
package org.eclipse.mddi.modelbus.adapter.infrastructure.transport.marshal.ws;


import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;

import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.ModelSerializer;
import org.eclipse.mddi.modelbus.adapter.user.ModelingServiceError;
import org.eclipse.mddi.modelbus.description.abstract_.Error;
import org.eclipse.mddi.modelbus.description.abstract_.Parameter;

public interface Marshaler {

       
    
    /**
     * Marshalls a parameter value 
     * and placed the result in the SOAP Element <code>topElem</code>.
     * 
     * <p>The value of each parameter is placed in a seperate XML tag.
     * For example, let <code>topElem</code> be the SOAP element &lt;my_service&gt;...&lt;/my_service&gt;.
     * Let the parameter name be "param1".
     * The parameter value will be placed in the SOAP element &lt;param1&gt;...&lt;/param1&gt; inside the element my_service.
     * 
     * <br><br> For model type, it must delegate to marshalModel(...)
     * 
     * @param p the description of the parameter, as defined in ModelBus metamodel.
     * @param parameterValue the value of the parameter to be marshalled
     * @param topElem the SOAPElement where the value of the parameter will be placed.
     * @throws SOAPException
     * @throws IOException
     * @throws Exception 
     * 
     */
    public void marshal(Parameter p, Object parameterValue, SOAPElement topElem) throws Exception;

    /**
     * Extracts the parameter value from the SOAP element <code>topElem</code>. 
     * 
     * <br><br> For model type, it must delegate to unmarshalModel(...)
     * 
     * @param p the description of the parameter, as defined in ModelBus metamodel.
     * @param topElem the SOAPElement from which the value of the parameter will be extracted.
     * @return the extracted value
     * @throws SOAPException
     * @throws IOException
     * @throws Exception 
     */
    public Object unmarshal(Parameter p, SOAPElement topElem)
            throws Exception;


    /**
     * 
     * marshal all parameter values to the specified top element
     * 
     * @param params an array of patameter definitions to marshall
     * @param parameterValues an array of parameter values
     * @param graph the graph that parameter values point to. It is a collection of model elements.
     * @param topElem
     * @throws Exception
     * 
     *
     */
    public void marshal(Parameter[] params, Object[] parameterValues,
            SOAPElement topElem) throws Exception;

    /**
     * 
     * unmarshal all parameter values to specified the top element
     * 
     * @param params an array of patameter definitions to marshall
     * @param topElem an array of parameter values
     * @return
     * @throws Exception
     * 
     *
     */
    public Object[] unmarshal(Parameter[] params, SOAPElement topElem) throws Exception;
    
   

    public ModelSerializer getSerializer();
    
    public void setSerializer(ModelSerializer serializer);
    
    public void marshalModelingServiceError(ModelingServiceError err,
            SOAPFault f) throws SOAPException;
    
 
    public ModelingServiceError unmarshalModelingServiceError(Error errorType,SOAPFault f) throws SOAPException;
}