/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */

package org.eclipse.mddi.modelbus.adapter.user;


import java.util.Properties;

import org.eclipse.mddi.modelbus.adapter.infrastructure.DeploymentException;
import org.eclipse.mddi.modelbus.adapter.infrastructure.notification.NotifServiceNotAvailableException;
import org.eclipse.mddi.modelbus.adapter.infrastructure.registry.ToolSelectionStrategy;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.ModelSerializer;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.TransportManager;
import org.eclipse.mddi.modelbus.adapter.user.consumer.GenericConsumer;
import org.eclipse.mddi.modelbus.adapter.user.consumer.NoToolAvailableException;
import org.eclipse.mddi.modelbus.adapter.user.consumer.SpecificConsumer;
import org.eclipse.mddi.modelbus.adapter.user.notification.NotificationPublisher;
import org.eclipse.mddi.modelbus.description.concrete.Tool;


/**
 *  This class represents the Adapter component.
 *	It provides operations for obtainning the interfaces offerred by the component.
 *
 * <p>The contraints defined in the class are the 'key' for the initialization properties of adapter.
 *
 * @author Prawee Sriplakich, Andrey Sadovykh (LIP6) 
 *
 */
public interface AdapterStub {
    
    
    public static final String PROP_REGISTRY_LOCATION = "registry_location";
    public static final String PROP_NOTIF_LOCATION = "notification_service_location";
    
    /**
     * @deprecated - the single port is used within an Adapter installation
     * The port for receving notifications from notification service.
     * default value: 8090
     */    
    public static final String PROP_NOTIF_RECEIVE_PORT = "notification_consumer_port";
    
    /**
     * this property corresponds to the topics in which the tool is interested. Comma-seperated string
     */
    public static final String PROP_NOTIF_TOPICS = "notification_service_topics";
    
    /**
     * The path referring to the tool description file. 
     * 
     */
    public static final String PROP_TOOL_DESC_FILE = "tool_desc_file";
	
    
    /**
     * This property is used internally in the adapter.
     * It stores the registration token (for later unregistering) 
     */
    public static final String PROP_REGISTRATION_TOKEN = "registry_token";
    
    
    /***
     * @deprecated - URL is constructed automatically
     * This property can be used to set up a custom URL for a provider tool.
     * In this case, this setting overides URL specified in the Tool Description 
     * and the provider tool is registered with this URL.
     *
     */
    public static final String PROP_PROVIDER_URL = "provider_url";

    /**
     * This property can be used to set up a PORT for listening to requests to a provider tool.
     * (Default value = 8081)
     *
     */
    public static final String MODELBUS_PORT = "modelbus_port";
    
    
    //////////////////////////////////////////////////////////////////////////////
    //    Properties for configuring the invocation mechanism
    ///////////////////////////////////////////////////////////////////////////////
    /**
     * Enable Adapter to choose a different invocation style than the default one.
     * Currently we provide the following styles : 
     *     Default, ResourceFragment
     * <br><br>
     * In the Default style, the a parameter value (model) is transmitted with the default EMF serialization:
     * The complete EMF resource will be transmitted.
     * 
     * <br><br>
     * The ResourceFragment supports the following advanced features
     *  - Model fragment transmission. Incomplete EMF resource can be transmitted.
     *  - In-place model update. If the PROP_doRestore is set to "true", then the call-by-copy-restore sematic is applied.
     *  I.e. the model of the caller can be updated by the service. 
     *  
     */    
    public static final String PROP_invocationStyle = "marshal.invocationStyle";
    public static final String PROP_invocationStyle_Default = "default";
    public static final String PROP_invocationStyle_ResourceFragment = "CopyRestoreFragment";
    
    /**
     * tell ModelBus to perform update propagation for INOUT.
     * This attribute is set only for the consumer side.
     */ 
    public static final String PROP_doRestore = "marshal.doRestore";
    /**
     * If the CopyRestoreFragment style is chosen, then the following properties can be set :
     * <br><br>
     * The model collection includes only top elements.
     * Then the Adapter transmit all the sub elements recursively
     */
    public static final String PROP_recursivelyIncludeSubelements = "marshal.recursivelyIncludeSubelements";    
    
    /**
     * @deprecated
     * Allows the tool to invoke Modeling Services of other tools via the Generic interface
     * @param toolName The name of the tool providing Modeling Services
     * @return an object responsible for invoking Modeling Services
     * @see getGenericConsumer()
     */
    public GenericConsumer getGenericServiceInvocation();
    
    /**
     * Allows the tool to invoke Modeling Services of other tools via the Generic interface
     * @param toolName The name of the tool providing Modeling Services
     * @return an object responsible for invoking Modeling Services
     */
    public GenericConsumer getGenericConsumer();
    
    /**
     * Allows the tool to invoke Modeling Services of other tools via tool-specific interfaces
     * @param toolName The name of the tool providing Modeling Services
     * @return an object responsible for invoking Modeling Services
     */
    public SpecificConsumer getSpecificServiceInvocation(String modelingServiceInterfaceName) 
    throws NoToolAvailableException;
    

	/**
	 * Allows the tool to publish notifications via its Adapter
	 * @return An object that allows publishing notifications
	 */
	public NotificationPublisher getNotificationPublisher() throws NotifServiceNotAvailableException;
	

	/**
	 * Allows obtaining the Tool implementation from the Adaptor
	 * @return Reference to a set of objects implementing Tool interfaces
	 */
	public ToolStub getToolStub();
	
	
	
	

	/**
	 * Allows consulting tool description 
	 * (for internal use inside ModelBus).
	 * @return an EMF object representing the tool description
	 */
	public Tool getToolDescription();

    /**
     * @param toolDescription The toolDescription to set.
     */
    public void setToolDescription(Tool toolDescription);
	


	
    /**
     * @return Returns the prop.
     */
    public Properties getProperties();



    /**
     * @return Returns the toolSelector.
     */
    public ToolSelectionStrategy getToolSelector();



    /**
     * set a custom tool selector.
     */
    public void setToolSelector(ToolSelectionStrategy toolSelector);
    

    
    /**
     * Deploys an Adapter to this server, so 1) it begins accepting service
     * invocation, and 2) receiving notifications.
     * 
     * 
     * @param adapter
     *            the Adapter object
     * @throws DeploymentException
     */     
    public void deploy() throws DeploymentException;
    
    /**
     * Undeploys an Adapter to this server. The result is 1) it will not accept
     * invocation anymore, and 2) it will not accept notifications anymore.
     * 
     * @throws DeploymentException
     */    
    public void undeploy() throws DeploymentException;



    /**
     * @return Returns the transportManager.
     */
    public TransportManager getTransportManager();

    /**
     * setSerializer can be used to plug custom model serializers 
     * 
     * @param serializer
     * 
     */
    
    public void setModelSerializer(ModelSerializer serializer);

    /**
     * @deprecated
     * setSerializer can be used to plug custom model serializers 
     * 
     * @param serializer
     * 
     */
    
    public void setSerializer(ModelSerializer serializer);


}
