/*
 * $RCSfile: Consumer.java,v $
 * $Date: 2006/03/13 16:18:05 $
 * $Revision: 1.2 $
 * $Author: xblanc $
 */
 
/*
 * Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.
 * All rights reserved.
 *
 * This software is published under the terms of the ModelBus Software License
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * A copy of ModelBus Software License is provided with this distribution in
 * doc/LICENSE.txt file.
 */
 
/*
 * Consumer.java
 * 
 * @author Prawee Sriplakich (LIP6)
 * @version $Revision: 1.2 $ $Date: 2006/03/13 16:18:05 $
 */
package org.eclipse.mddi.modelbus.adapter.test.anno;

import java.io.IOException;
import java.util.Collection;
import java.util.Properties;
import java.util.Vector;

import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.impl.EcorePackageImpl;

import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.emf_xmi.Emf2XmiConversion;
import org.eclipse.mddi.modelbus.adapter.test.registry.BasicRegistry;
import org.eclipse.mddi.modelbus.adapter.user.AdapterStub;
import org.eclipse.mddi.modelbus.adapter.user.consumer.GenericConsumer;
import org.eclipse.mddi.modelbus.adapter.user.impl.AdapterStubImpl;

import org.eclipse.uml2.Class;
import org.eclipse.uml2.Package;
import org.eclipse.uml2.UML2Factory;
import org.eclipse.uml2.impl.UML2PackageImpl;


public class Consumer {
    
    public static String REG = BasicRegistry.getUrl();       

    /**
     * main
     * 
     * @param args
     * @throws DeploymentException 
     * @throws ModelBusCommunicationException 
     * @throws ModelTypeMismatchException 
     * @throws NoToolAvailableException 
     * @throws ServiceUnknownException 
     * @throws ModelingServiceError 
     * @throws IOException 
     * 
     *
     */

    public static void main(String[] args) throws Exception {
        Properties p;
        p = new Properties();
        p.put(AdapterStub.PROP_REGISTRY_LOCATION, REG);
        AdapterStub stub = new AdapterStubImpl(p);       

        GenericConsumer si = stub.getGenericConsumer();
        
        Collection model = generateModel();
        Object[] params = { model  };
        
        Object[] result = si.consume("inoutModelService", params);
        
        showResult((Collection)result[0]);

    }
    
    
    public static Collection generateModel() {
        UML2Factory f = UML2PackageImpl.init().getUML2Factory();        
        Collection r = new Vector();
        
        EcoreFactory ef = EcorePackageImpl.init().getEcoreFactory();
        
        Package pack = f.createPackage();
        for(int i=0; i<10; i++) {
            Class c = f.createClass();
            c.setName("Class" +i);
            pack.getOwnedMembers().add(c);
 
            EAnnotation anno = ef.createEAnnotation();
            anno.setSource("consumer:annotation" + i +"=" + i);
            c.getEAnnotations().add(anno);                        
        }
        
        r.add(pack);
        return r;
    }
    
    
    static void showResult(Collection model) throws IOException {
        System.out.println("Result:");
        System.out.println(Emf2XmiConversion.convertToString(model) );
    }

}
