/*
 * Created on 11 juil. 2006 by Nicolas Garandeau (lip6)
*/

package org.eclipse.mddi.modelbus.adapter.test.asynchronous;

import java.util.Properties;

import org.apache.log4j.Logger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.LoggerConfigurator;
import org.eclipse.mddi.modelbus.adapter.test.framework.ProviderTest;
import org.eclipse.mddi.modelbus.adapter.test.registry.BasicRegistry;
import org.eclipse.mddi.modelbus.adapter.user.AdapterStub;
import org.eclipse.mddi.modelbus.adapter.user.impl.AdapterStubImpl;
import org.eclipse.mddi.modelbus.adapter.user.provider.GenericProvider;

public class AsyncLocalProviderAndConsumer {


    ProviderTest test;
    Properties prop;
    
    AdapterStub adapter =null;
    
    private static Logger logger=Logger.getLogger(AsyncProvider.class);
    
    public AsyncLocalProviderAndConsumer(Properties p) {
        LoggerConfigurator.configure();
        prop = p;
    }    

    /**
     * Deploys the provider tool and launch the local consummation
     * 
     * @throws Exception
     */
    public void runTest() throws Exception {

    	providerPart();
   	logger.info("Provider part ready"); 
    	Thread.sleep(3000);
    	logger.info("Launching local consummation");
      consumerPart();
      
      undeployTest();

        
    }
    




	private void providerPart() throws Exception {
		adapter = new AdapterStubImpl(prop);
		GenericProvider provider = new SortModelingServiceImpl(); 
		adapter.getToolStub().setProvider(provider);		
		adapter.deploy();
	}
	
	
	private void consumerPart() throws Exception{
		
		AdapterStub adapter =null;
		ConsumerAsyncTest test;
		if (adapter == null) {
			adapter = new AdapterStubImpl(prop);
		}
		Object[] inputs = new Object[1];
		inputs[0] = "436";
		test = new ConsumerAsyncTest(adapter, "sort", inputs);
		logger.info("Starting asynchronous consommation");   
		String conId = test.consumeAsync();
		logger.info("Asynchronous consommation launched with identifier "+conId); 
		while(!test.isResultReady(conId)){
			logger.info("result not ready");
			Thread.sleep(500);
		}
		logger.info("result ready");
		Object[] result = test.getResult(conId);
		logger.info(" result : "+result[0]+ "\n The test has successfully finished.");
	}
	

	public void undeployTest() throws Exception {
        adapter.undeploy();        
    }
    
    
    
    
    public static boolean isStarted = false;
    
    public static void main(String args[]) {
    	if(isStarted) return;
        
        String registry_loc;
        if(args.length>0) {
          registry_loc = args[0];
        } else {
          registry_loc = BasicRegistry.getUrl();
        }
        
        String desc_file;
        if(args.length>1) {
            desc_file = args[1];
        } else {
            desc_file = "./src/org/eclipse/mddi/modelbus/adapter/test/asynchronous/sort.description";
        }
        
        try {
            
            Properties p = new Properties();
            
            p.put(AdapterStub.PROP_REGISTRY_LOCATION, registry_loc);
            p.put(AdapterStub.PROP_TOOL_DESC_FILE , desc_file);
           
            
            AsyncLocalProviderAndConsumer testSample = new AsyncLocalProviderAndConsumer(p);
            testSample.runTest();
        } catch (Exception e) {
            e.printStackTrace();
            System.exit(0);            
        }
       

    }
    

}
