/*
 * Created on 18 avr. 2006
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.eclipse.mddi.modelbus.adapter.test.asynchronous;

import java.io.IOException;
import java.util.Collection;

import org.apache.log4j.Logger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.emf_xmi.Emf2XmiConversion;
import org.eclipse.mddi.modelbus.adapter.test.framework.AdapterTest;
import org.eclipse.mddi.modelbus.adapter.test.framework.ConsumerTest;
import org.eclipse.mddi.modelbus.adapter.user.AdapterStub;
import org.eclipse.mddi.modelbus.adapter.user.consumer.GenericConsumer;
import org.eclipse.mddi.modelbus.adapter.user.consumer.ModelBusCommunicationException;
import org.eclipse.mddi.modelbus.adapter.user.consumer.ServiceUnknownException;

/**
 * @author Nicolas Garandeau (LIP6)
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class ConsumerAsyncTest  extends AdapterTest {
    
    Object[] inputs;
    Object[] outputs;
    
    String serviceName;
    
    private static Logger logger=Logger.getLogger(ConsumerTest.class);
    
    
    
    public ConsumerAsyncTest(AdapterStub _adapter, String _serviceName, Object[] _inputs) {
        setAdapter(_adapter);
        setServiceName(_serviceName);
        setInputs(_inputs);

    }
    
    public Object[] getInputs() {
      return inputs;
    }
    
    public void setInputs(Object[] _inputs) {
          inputs = _inputs;
    } 
   
    public void consume() throws Exception {
        GenericConsumer consumer = getAdapter().getGenericConsumer();
        outputs = consumer.consume(serviceName, inputs);
       
    }
    
    
    public void consume(String sessionId) throws Exception {
        GenericConsumer consumer = getAdapter().getGenericConsumer();
        outputs = consumer.consume(serviceName, inputs,sessionId);
       
    }
    
    public String consumeAsync() throws Exception {
    	GenericConsumer consumer = getAdapter().getGenericConsumer();
        return consumer.consumeAsync(serviceName, inputs);
       
    }
    
    public String consumeAsync(String sessionId) throws Exception {
    	GenericConsumer consumer = getAdapter().getGenericConsumer();
        return getAdapter().getGenericConsumer().consumeAsync(serviceName, inputs,sessionId);
       
    }
    
    

    
    public boolean isResultReady(String resultHolderId) throws Exception{
    	GenericConsumer consumer = getAdapter().getGenericConsumer();
        boolean ready = consumer.isResultReady(resultHolderId);
        return ready;
    }

    public Object[] getResult(String resultHolderId) throws Exception{
    	GenericConsumer consumer = getAdapter().getGenericConsumer();
        Object[] result = consumer.getResult(resultHolderId);
        return result;
    }
    
    
    public String openSession()throws Exception{
    	GenericConsumer consumer = getAdapter().getGenericConsumer();
    	return consumer.newSession(serviceName);

    }
    
    public void closeSession(String sessionId) throws Exception{
    	GenericConsumer consumer = getAdapter().getGenericConsumer();
    	consumer.endSession(sessionId);
    }


    public Object[] getOutputs() {
        return outputs;
    }
    
    public void printOutputs() {
        logger.info(getOutputsString());
    }
    
    public String getOutputsString() {
       String s = "";
       for(int i=0; i<1; i++) {
           s = s + "output" +i +" "+getString(outputs[i]) +"\n";
       }    
       return s;
    }
    
    public String getString(Object value) {
      if(value instanceof Collection) {
        // it is a model
        Collection c = (Collection) value;
        try {
            String result = Emf2XmiConversion.convertToString(c);
            return result;
        } catch (IOException e) {
            return "ERROR";
        }
        
      } else if(value instanceof Object[]) {
          Object[] array = (Object[]) value; 
          String result = "{";
          for(int i=0; i<array.length; i++) { 
             result = result + getString(array[i]); 
      	  }
          return result + " }"; 
      } else if(value==null) {
        return "null";    
      } else return value.toString();
    }
    

    public String getServiceName() {
        return serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }
}
